/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.getlime.security.powerauth.biometry.IBiometricAuthenticationCallback;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.sdk.impl.CancelableTask;
import io.getlime.security.powerauth.sdk.impl.ICallbackDispatcher;

public class BiometricResultDispatcher {
    @NonNull
    private final IBiometricAuthenticationCallback callback;
    @NonNull
    private final ICallbackDispatcher callbackDispatcher;
    @NonNull
    private final CancelableTask cancelable;
    @Nullable
    private CancelableTask.OnCancelListener onCancelListener;
    private boolean isDispatched = false;

    public BiometricResultDispatcher(final @NonNull IBiometricAuthenticationCallback callback, final @NonNull ICallbackDispatcher callbackDispatcher) {
        this.callback = callback;
        this.callbackDispatcher = callbackDispatcher;
        this.cancelable = new CancelableTask(new CancelableTask.OnCancelListener(){

            @Override
            public void onCancel() {
                callbackDispatcher.dispatchCallback(new Runnable(){

                    @Override
                    public void run() {
                        if (!BiometricResultDispatcher.this.isDispatched) {
                            BiometricResultDispatcher.this.isDispatched = true;
                            if (BiometricResultDispatcher.this.onCancelListener != null) {
                                BiometricResultDispatcher.this.onCancelListener.onCancel();
                            }
                            callback.onBiometricDialogCancelled(false);
                        }
                    }
                });
            }
        });
    }

    public void setOnCancelListener(@NonNull CancelableTask.OnCancelListener onCancelListener) {
        this.onCancelListener = onCancelListener;
    }

    @NonNull
    public CancelableTask getCancelableTask() {
        return this.cancelable;
    }

    public void dispatchSuccess(final @NonNull byte[] encryptedKey) {
        this.dispatch(new Runnable(){

            @Override
            public void run() {
                BiometricResultDispatcher.this.callback.onBiometricDialogSuccess(encryptedKey);
            }
        });
    }

    public void dispatchUserCancel() {
        this.dispatch(new Runnable(){

            @Override
            public void run() {
                BiometricResultDispatcher.this.callback.onBiometricDialogCancelled(true);
            }
        });
    }

    public void dispatchError(int code, @NonNull String message) {
        this.dispatchError(new PowerAuthErrorException(code, message));
    }

    public void dispatchError(final @NonNull PowerAuthErrorException exception) {
        this.dispatch(new Runnable(){

            @Override
            public void run() {
                BiometricResultDispatcher.this.callback.onBiometricDialogFailed(exception);
            }
        });
    }

    private void dispatch(final @NonNull Runnable runnable) {
        this.callbackDispatcher.dispatchCallback(new Runnable(){

            @Override
            public void run() {
                if (!BiometricResultDispatcher.this.cancelable.isCancelled() && !BiometricResultDispatcher.this.isDispatched) {
                    BiometricResultDispatcher.this.isDispatched = true;
                    runnable.run();
                }
            }
        });
    }
}

