/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.getlime.security.powerauth.core.ActivationStatus;
import io.getlime.security.powerauth.core.ProtocolUpgradeData;
import io.getlime.security.powerauth.core.ProtocolVersion;
import io.getlime.security.powerauth.core.Session;
import io.getlime.security.powerauth.core.SignatureUnlockKeys;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.networking.client.HttpClient;
import io.getlime.security.powerauth.networking.endpoints.GetActivationStatusEndpoint;
import io.getlime.security.powerauth.networking.endpoints.UpgradeCommitV3Endpoint;
import io.getlime.security.powerauth.networking.endpoints.UpgradeStartV3Endpoint;
import io.getlime.security.powerauth.networking.interfaces.ICancelable;
import io.getlime.security.powerauth.networking.interfaces.INetworkResponseListener;
import io.getlime.security.powerauth.networking.response.IActivationStatusListener;
import io.getlime.security.powerauth.rest.api.model.request.v2.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.ActivationStatusResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.UpgradeResponsePayload;
import io.getlime.security.powerauth.sdk.PowerAuthAuthentication;
import io.getlime.security.powerauth.sdk.impl.ICallbackDispacher;
import io.getlime.security.powerauth.sdk.impl.IPrivateCryptoHelper;
import io.getlime.security.powerauth.system.PA2Log;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class GetActivationStatusTask
implements ICancelable {
    private final HttpClient httpClient;
    private final Session session;
    private final IPrivateCryptoHelper cryptoHelper;
    private final ICompletionListener completionListener;
    private final ICallbackDispacher callbackDispacher;
    private final AtomicBoolean isExiting = new AtomicBoolean();
    private final AtomicBoolean isCanceled = new AtomicBoolean();
    private final ArrayList<ChildTask> childTasks = new ArrayList();
    private ICancelable pendingOperation;
    private boolean isUpgradeDisabled;
    private boolean isStarted = false;
    private ActivationStatus lastFetchedStatus;
    private int protocolUpgradeAttempts;

    public GetActivationStatusTask(@NonNull HttpClient httpClient, @NonNull IPrivateCryptoHelper cryptoHelper, @NonNull Session session, @NonNull ICallbackDispacher callbackDispacher, @NonNull ICompletionListener completionListener) {
        this.httpClient = httpClient;
        this.session = session;
        this.cryptoHelper = cryptoHelper;
        this.callbackDispacher = callbackDispacher;
        this.completionListener = completionListener;
        this.pendingOperation = null;
    }

    public boolean isUpgradeDisabled() {
        return this.isUpgradeDisabled;
    }

    public void setUpgradeDisabled(boolean upgradeDisabled) {
        this.isUpgradeDisabled = upgradeDisabled;
    }

    public void execute() {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        this.lastFetchedStatus = null;
        this.protocolUpgradeAttempts = 3;
        this.fetchActivationStatusAndTestUpgrade();
    }

    private void fetchActivationStatusAndTestUpgrade() {
        this.fetchActivationStatus(new IActivationStatusListener(){

            @Override
            public void onActivationStatusSucceed(ActivationStatus status) {
                if (status.isUpgradeAvailable || GetActivationStatusTask.this.session.hasPendingProtocolUpgrade()) {
                    if (!GetActivationStatusTask.this.isUpgradeDisabled) {
                        GetActivationStatusTask.this.continueWithUpgrade(status);
                        return;
                    }
                    PA2Log.e("WARNING: Upgrade to newer protocol version is disabled.", new Object[0]);
                }
                GetActivationStatusTask.this.completeTask(status, null);
            }

            @Override
            public void onActivationStatusFailed(Throwable t) {
                GetActivationStatusTask.this.completeTask(null, t);
            }
        });
    }

    private void fetchActivationStatus(final @NonNull IActivationStatusListener listener) {
        ActivationStatusRequest request = new ActivationStatusRequest();
        request.setActivationId(this.session.getActivationIdentifier());
        this.pendingOperation = this.httpClient.post(request, new GetActivationStatusEndpoint(), this.cryptoHelper, new INetworkResponseListener<ActivationStatusResponse>(){

            @Override
            public void onNetworkResponse(ActivationStatusResponse response) {
                GetActivationStatusTask.this.pendingOperation = null;
                SignatureUnlockKeys keys = new SignatureUnlockKeys(GetActivationStatusTask.this.cryptoHelper.getDeviceRelatedKey(), null, null);
                ActivationStatus activationStatus = GetActivationStatusTask.this.session.decodeActivationStatus(response.getEncryptedStatusBlob(), keys);
                if (activationStatus != null) {
                    activationStatus.setCustomObject(response.getCustomObject());
                    listener.onActivationStatusSucceed(activationStatus);
                } else {
                    listener.onActivationStatusFailed(new PowerAuthErrorException(4));
                }
            }

            @Override
            public void onNetworkError(Throwable t) {
                GetActivationStatusTask.this.pendingOperation = null;
                listener.onActivationStatusFailed(t);
            }

            @Override
            public void onCancel() {
                GetActivationStatusTask.this.pendingOperation = null;
            }
        });
    }

    private void serializeSessionState() {
        this.completionListener.onSessionStateChange();
    }

    private void continueWithUpgrade(@NonNull ActivationStatus status) {
        this.lastFetchedStatus = status;
        if (this.protocolUpgradeAttempts-- > 0) {
            this.continueWithUpgradeToV3(status);
        } else {
            PowerAuthErrorException error = new PowerAuthErrorException(1, "Number of upgrade attempts reached its maximum.");
            this.completeTask(null, error);
        }
    }

    private void continueWithUpgradeToV3(@NonNull ActivationStatus status) {
        this.lastFetchedStatus = status;
        ProtocolVersion serverVersion = status.currentVersion;
        ProtocolVersion localVersion = this.session.getProtocolVersion();
        if (serverVersion == ProtocolVersion.V2) {
            if (this.session.getPendingProtocolUpgradeVersion() == ProtocolVersion.NA) {
                PA2Log.d("ProtocolUpgrade: Starting activation upgrade to protocol V3", new Object[0]);
                if (this.session.startProtocolUpgrade() != 0) {
                    this.completeTaskWithUpgradeError("Protocol upgrade start failed.");
                    return;
                }
                this.serializeSessionState();
            }
            if (localVersion == ProtocolVersion.V2) {
                this.startUpgradeToV3();
                return;
            }
            if (localVersion == ProtocolVersion.V3) {
                this.commitUpgradeToV3();
                return;
            }
        } else if (serverVersion == ProtocolVersion.V3) {
            if (localVersion == ProtocolVersion.V2) {
                this.completeTaskWithUpgradeError("Server-Client protocol version mishmash.");
                return;
            }
            if (localVersion == ProtocolVersion.V3) {
                ProtocolVersion pendingUpgradeVersion = this.session.getPendingProtocolUpgradeVersion();
                if (pendingUpgradeVersion == ProtocolVersion.V3) {
                    this.finishUpgradeToV3();
                    return;
                }
                if (pendingUpgradeVersion == ProtocolVersion.NA) {
                    this.completeTask(this.lastFetchedStatus, null);
                    return;
                }
            }
        } else {
            this.completeTaskWithUpgradeError("Unknown server version.");
            return;
        }
        this.completeTaskWithUpgradeError("Internal protocol upgrade error.");
    }

    private void startUpgradeToV3() {
        this.pendingOperation = this.httpClient.post(null, new UpgradeStartV3Endpoint(), this.cryptoHelper, new INetworkResponseListener<UpgradeResponsePayload>(){

            @Override
            public void onNetworkResponse(UpgradeResponsePayload response) {
                GetActivationStatusTask.this.pendingOperation = null;
                ProtocolUpgradeData upgradeData = ProtocolUpgradeData.version3(response.getCtrData());
                if (GetActivationStatusTask.this.session.applyProtocolUpgradeData(upgradeData) == 0) {
                    GetActivationStatusTask.this.serializeSessionState();
                    GetActivationStatusTask.this.commitUpgradeToV3();
                } else {
                    GetActivationStatusTask.this.completeTaskWithUpgradeError("Failed to apply upgrade data.");
                }
            }

            @Override
            public void onNetworkError(Throwable throwable) {
                GetActivationStatusTask.this.pendingOperation = null;
                GetActivationStatusTask.this.fetchActivationStatusAndTestUpgrade();
            }

            @Override
            public void onCancel() {
                GetActivationStatusTask.this.pendingOperation = null;
            }
        });
    }

    private void commitUpgradeToV3() {
        PowerAuthAuthentication authentication = new PowerAuthAuthentication();
        authentication.usePossession = true;
        this.pendingOperation = this.httpClient.post(null, new UpgradeCommitV3Endpoint(), this.cryptoHelper, authentication, new INetworkResponseListener<Void>(){

            @Override
            public void onNetworkResponse(Void o) {
                GetActivationStatusTask.this.pendingOperation = null;
                GetActivationStatusTask.this.finishUpgradeToV3();
            }

            @Override
            public void onNetworkError(Throwable throwable) {
                GetActivationStatusTask.this.pendingOperation = null;
                GetActivationStatusTask.this.fetchActivationStatusAndTestUpgrade();
            }

            @Override
            public void onCancel() {
                GetActivationStatusTask.this.pendingOperation = null;
            }
        });
    }

    private void finishUpgradeToV3() {
        if (this.session.finishProtocolUpgrade() == 0) {
            PA2Log.d("ProtocolUpgrade: Activation was successfully upgraded to protocol V3.", new Object[0]);
            this.serializeSessionState();
            this.completeTask(this.lastFetchedStatus, null);
        } else {
            this.completeTaskWithUpgradeError("Failed to complete the upgrade process.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.isCanceled.set(true);
        GetActivationStatusTask getActivationStatusTask = this;
        synchronized (getActivationStatusTask) {
            if (this.pendingOperation != null) {
                this.pendingOperation.cancel();
                this.pendingOperation = null;
            }
        }
        this.completeTask(null, null);
    }

    @Override
    public boolean isCancelled() {
        return this.isCanceled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeTask(@Nullable ActivationStatus status, @Nullable Throwable throwable) {
        ArrayList<ChildTask> tasksToReport;
        if (this.isExiting.getAndSet(true)) {
            return;
        }
        if (status == null && throwable == null) {
            throwable = new PowerAuthErrorException(11, "Operation was canceled from elsewhere.");
        }
        GetActivationStatusTask getActivationStatusTask = this;
        synchronized (getActivationStatusTask) {
            tasksToReport = new ArrayList<ChildTask>(this.childTasks);
            this.childTasks.clear();
        }
        if (status != null) {
            this.completionListener.onSuccess(this, status);
        } else {
            this.completionListener.onFailure(this);
        }
        for (ChildTask task : tasksToReport) {
            task.complete(status, throwable);
        }
    }

    private void completeTaskWithUpgradeError(@NonNull String message) {
        this.completeTask(null, new PowerAuthErrorException(16, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ICancelable addActivationStatusListener(@NonNull IActivationStatusListener listener) {
        GetActivationStatusTask getActivationStatusTask = this;
        synchronized (getActivationStatusTask) {
            if (!this.isExiting.get()) {
                ChildTask task = new ChildTask(listener);
                this.childTasks.add(task);
                return task;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeActivationStatusListener(@NonNull ChildTask task) {
        GetActivationStatusTask getActivationStatusTask = this;
        synchronized (getActivationStatusTask) {
            this.childTasks.remove(task);
        }
    }

    private class ChildTask
    implements ICancelable {
        private final IActivationStatusListener listener;
        private final AtomicBoolean isCanceled = new AtomicBoolean();

        ChildTask(IActivationStatusListener listener) {
            this.listener = listener;
        }

        @Override
        public void cancel() {
            this.isCanceled.set(true);
            GetActivationStatusTask.this.removeActivationStatusListener(this);
        }

        @Override
        public boolean isCancelled() {
            return this.isCanceled.get();
        }

        public void complete(final @Nullable ActivationStatus status, final @Nullable Throwable throwable) {
            if (!this.isCanceled.getAndSet(true)) {
                GetActivationStatusTask.this.callbackDispacher.dispatchCallback(new Runnable(){

                    @Override
                    public void run() {
                        if (status != null) {
                            ChildTask.this.listener.onActivationStatusSucceed(status);
                        } else {
                            ChildTask.this.listener.onActivationStatusFailed(throwable);
                        }
                    }
                });
            }
        }
    }

    public static interface ICompletionListener {
        public void onSessionStateChange();

        public void onSuccess(@NonNull GetActivationStatusTask var1, @NonNull ActivationStatus var2);

        public void onFailure(@NonNull GetActivationStatusTask var1);
    }
}

