/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.keychain.fingerprint;

import android.content.Context;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;

@RequiresApi(api=23)
public class FingerprintUtilities {
    private static FingerprintManager fingerprintManager(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return (FingerprintManager)context.getSystemService("fingerprint");
        }
        return null;
    }

    public static boolean isFingerprintAuthAvailable(@NonNull Context context) throws SecurityException {
        FingerprintManager mFingerprintManager = FingerprintUtilities.fingerprintManager(context);
        return mFingerprintManager != null && mFingerprintManager.isHardwareDetected() && mFingerprintManager.hasEnrolledFingerprints();
    }

    public static boolean hasFingerprintHardware(@NonNull Context context) throws SecurityException {
        FingerprintManager mFingerprintManager = FingerprintUtilities.fingerprintManager(context);
        return mFingerprintManager != null && mFingerprintManager.isHardwareDetected();
    }

    public static boolean hasEnrolledFingerprints(@NonNull Context context) throws SecurityException {
        FingerprintManager mFingerprintManager = FingerprintUtilities.fingerprintManager(context);
        return mFingerprintManager != null && mFingerprintManager.hasEnrolledFingerprints();
    }
}

