/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.e2ee;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.core.EncryptedMessage;
import io.getlime.security.powerauth.core.Encryptor;
import io.getlime.security.powerauth.e2ee.PA2EncryptionFailedException;
import io.getlime.security.powerauth.e2ee.PA2Encryptor;
import io.getlime.security.powerauth.rest.api.model.entity.NonPersonalizedEncryptedPayloadModel;
import java.io.UnsupportedEncodingException;

public class PA2RequestResponseNonPersonalizedEncryptor
implements PA2Encryptor {
    private Encryptor encryptor;
    private Gson objectMapper = new GsonBuilder().create();

    public PA2RequestResponseNonPersonalizedEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public void setObjectMapper(Gson objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public ObjectRequest<NonPersonalizedEncryptedPayloadModel> encryptRequestData(byte[] originalData) throws PA2EncryptionFailedException {
        EncryptedMessage encryptedMessage = this.encryptor.encrypt(originalData);
        if (encryptedMessage == null) {
            throw new PA2EncryptionFailedException();
        }
        NonPersonalizedEncryptedPayloadModel requestObject = new NonPersonalizedEncryptedPayloadModel();
        requestObject.setApplicationKey(encryptedMessage.applicationKey);
        requestObject.setSessionIndex(encryptedMessage.sessionIndex);
        requestObject.setAdHocIndex(encryptedMessage.adHocIndex);
        requestObject.setMacIndex(encryptedMessage.macIndex);
        requestObject.setNonce(encryptedMessage.nonce);
        requestObject.setEphemeralPublicKey(encryptedMessage.ephemeralPublicKey);
        requestObject.setMac(encryptedMessage.mac);
        requestObject.setEncryptedData(encryptedMessage.encryptedData);
        ObjectRequest request = new ObjectRequest((Object)requestObject);
        return request;
    }

    @Override
    public ObjectRequest<NonPersonalizedEncryptedPayloadModel> encryptRequestData(Object requestObject) throws PA2EncryptionFailedException {
        try {
            byte[] bytes = this.objectMapper.toJson(requestObject).getBytes("UTF-8");
            return this.encryptRequestData(bytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @Override
    public byte[] decryptResponse(ObjectResponse<NonPersonalizedEncryptedPayloadModel> response) throws PA2EncryptionFailedException {
        NonPersonalizedEncryptedPayloadModel responseObject = (NonPersonalizedEncryptedPayloadModel)response.getResponseObject();
        EncryptedMessage encryptedMessage = new EncryptedMessage(responseObject.getApplicationKey(), null, responseObject.getEncryptedData(), responseObject.getMac(), responseObject.getSessionIndex(), responseObject.getAdHocIndex(), responseObject.getMacIndex(), responseObject.getNonce(), responseObject.getEphemeralPublicKey());
        byte[] originalData = this.encryptor.decrypt(encryptedMessage);
        if (this.encryptor.lastErrorCode != 0) {
            throw new PA2EncryptionFailedException();
        }
        return originalData;
    }

    @Override
    public <T> T decryptResponse(ObjectResponse<NonPersonalizedEncryptedPayloadModel> response, Class<T> responseType) throws PA2EncryptionFailedException {
        try {
            byte[] originalData = this.decryptResponse(response);
            return (T)this.objectMapper.fromJson(new String(originalData, "UTF-8"), responseType);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

