/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.networking.client;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import io.getlime.security.powerauth.networking.endpoints.PA2ActivationStatusEndpoint;
import io.getlime.security.powerauth.networking.endpoints.PA2CreateActivationEndpoint;
import io.getlime.security.powerauth.networking.endpoints.PA2NonPersonalizedEncryptedEndpoint;
import io.getlime.security.powerauth.networking.endpoints.PA2RemoveActivationEndpoint;
import io.getlime.security.powerauth.networking.endpoints.PA2VaultUnlockEndpoint;
import io.getlime.security.powerauth.networking.exceptions.ErrorResponseApiException;
import io.getlime.security.powerauth.networking.exceptions.FailedApiException;
import io.getlime.security.powerauth.networking.interfaces.IEndpointDefinition;
import io.getlime.security.powerauth.networking.interfaces.INetworkResponseListener;
import io.getlime.security.powerauth.networking.ssl.PA2ClientValidationStrategy;
import io.getlime.security.powerauth.rest.api.model.base.PowerAuthApiRequest;
import io.getlime.security.powerauth.rest.api.model.entity.ErrorModel;
import io.getlime.security.powerauth.rest.api.model.entity.NonPersonalizedEncryptedPayloadModel;
import io.getlime.security.powerauth.rest.api.model.request.ActivationCreateRequest;
import io.getlime.security.powerauth.rest.api.model.request.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.response.ActivationCreateCustomResponse;
import io.getlime.security.powerauth.rest.api.model.response.ActivationStatusResponse;
import io.getlime.security.powerauth.rest.api.model.response.VaultUnlockResponse;
import io.getlime.security.powerauth.sdk.PowerAuthClientConfiguration;
import io.getlime.security.powerauth.sdk.PowerAuthConfiguration;
import io.getlime.security.powerauth.system.PA2Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

public class PA2Client {
    private final Gson mGson = new GsonBuilder().create();
    private final Handler mHandler = new Handler(Looper.getMainLooper());

    private String loadStringFromInputStream(InputStream is, String encoding) throws IOException {
        int length;
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return result.toString(encoding);
    }

    private <TResponse> void callOnResponseUi(final TResponse response, final INetworkResponseListener<TResponse> responseListener) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                responseListener.onNetworkResponse(response);
            }
        });
    }

    private <TResponse> void callOnErrorUi(final Throwable t, final INetworkResponseListener<TResponse> responseListener) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                responseListener.onNetworkError(t);
            }
        });
    }

    private <TRequest, TResponse> AsyncTask execute(@NonNull PowerAuthConfiguration configuration, @NonNull PowerAuthClientConfiguration clientConfiguration, @NonNull IEndpointDefinition<TResponse> requestDefinition, @Nullable TRequest requestBody, @Nullable Map<String, String> headers, @NonNull INetworkResponseListener<TResponse> responseListener) {
        RestExecutor restExecutor = new RestExecutor(clientConfiguration, headers, requestDefinition, responseListener);
        return restExecutor.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Object[]{requestBody, null, null});
    }

    @CheckResult
    public AsyncTask sendNonPersonalizedEncryptedObjectToUrl(@NonNull PowerAuthConfiguration configuration, @NonNull PowerAuthClientConfiguration clientConfiguration, @NonNull NonPersonalizedEncryptedPayloadModel request, @NonNull String url, @NonNull Map<String, String> headers, @NonNull INetworkResponseListener<NonPersonalizedEncryptedPayloadModel> listener) {
        return this.execute(configuration, clientConfiguration, new PA2NonPersonalizedEncryptedEndpoint(url), request, headers, listener);
    }

    @CheckResult
    public AsyncTask createActivation(@NonNull PowerAuthConfiguration configuration, @NonNull PowerAuthClientConfiguration clientConfiguration, @NonNull ActivationCreateRequest request, @NonNull INetworkResponseListener<ActivationCreateCustomResponse> listener) {
        return this.execute(configuration, clientConfiguration, new PA2CreateActivationEndpoint(configuration.getBaseEndpointUrl()), request, null, listener);
    }

    @CheckResult
    public AsyncTask getActivationStatus(@NonNull PowerAuthConfiguration configuration, @NonNull PowerAuthClientConfiguration clientConfiguration, @NonNull ActivationStatusRequest request, @NonNull INetworkResponseListener<ActivationStatusResponse> listener) {
        return this.execute(configuration, clientConfiguration, new PA2ActivationStatusEndpoint(configuration.getBaseEndpointUrl()), request, null, listener);
    }

    @CheckResult
    public AsyncTask removeActivationSignatureHeader(@NonNull PowerAuthConfiguration configuration, @NonNull PowerAuthClientConfiguration clientConfiguration, @NonNull Map<String, String> headers, @NonNull INetworkResponseListener<Void> listener) {
        return this.execute(configuration, clientConfiguration, new PA2RemoveActivationEndpoint(configuration.getBaseEndpointUrl()), null, headers, listener);
    }

    @CheckResult
    public AsyncTask vaultUnlockSignatureHeader(@NonNull PowerAuthConfiguration configuration, @NonNull PowerAuthClientConfiguration clientConfiguration, @NonNull Map<String, String> headers, @NonNull INetworkResponseListener<VaultUnlockResponse> listener) {
        return this.execute(configuration, clientConfiguration, new PA2VaultUnlockEndpoint(configuration.getBaseEndpointUrl()), null, headers, listener);
    }

    private class RestExecutor<TRequest, TResponse>
    extends AsyncTask<TRequest, Void, Void> {
        private static final String CONTENT_TYPE_JSON = "application/json";
        private PowerAuthClientConfiguration clientConfiguration;
        private IEndpointDefinition<TRequest> requestDefinition;
        private INetworkResponseListener<TResponse> responseListener;
        @Nullable
        private Map<String, String> headers;

        private RestExecutor(@Nullable PowerAuthClientConfiguration clientConfiguration, @NonNull Map<String, String> headers, @NonNull IEndpointDefinition<TRequest> requestDefinition, INetworkResponseListener<TResponse> responseListener) {
            this.clientConfiguration = clientConfiguration;
            this.headers = headers;
            this.requestDefinition = requestDefinition;
            this.responseListener = responseListener;
        }

        protected Void doInBackground(TRequest ... params) {
            URL url;
            try {
                url = new URL(this.requestDefinition.getEndpoint());
            }
            catch (MalformedURLException e) {
                PA2Client.this.callOnErrorUi(e, this.responseListener);
                return null;
            }
            try {
                PowerAuthApiRequest requestObject = new PowerAuthApiRequest(params[0]);
                String jsonRequestObject = PA2Client.this.mGson.toJson((Object)requestObject);
                byte[] postDataBytes = jsonRequestObject.getBytes("UTF-8");
                HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                boolean securedUrlConnection = urlConnection instanceof HttpsURLConnection;
                urlConnection.setRequestMethod("POST");
                urlConnection.setDoOutput(true);
                urlConnection.setUseCaches(false);
                urlConnection.setRequestProperty("Content-Type", CONTENT_TYPE_JSON);
                urlConnection.setRequestProperty("Accept", CONTENT_TYPE_JSON);
                if (this.headers != null) {
                    for (Map.Entry<String, String> header : this.headers.entrySet()) {
                        urlConnection.setRequestProperty(header.getKey(), header.getValue());
                    }
                }
                urlConnection.setConnectTimeout(this.clientConfiguration.getConnectionTimeout());
                urlConnection.setReadTimeout(this.clientConfiguration.getReadTimeout());
                if (securedUrlConnection) {
                    PA2ClientValidationStrategy clientValidationStrategy = this.clientConfiguration.getClientValidationStrategy();
                    if (clientValidationStrategy != null) {
                        HostnameVerifier hostnameVerifier;
                        HttpsURLConnection sslConnection = (HttpsURLConnection)urlConnection;
                        SSLSocketFactory sslSocketFactory = clientValidationStrategy.getSSLSocketFactory();
                        if (sslSocketFactory != null) {
                            sslConnection.setSSLSocketFactory(sslSocketFactory);
                        }
                        if ((hostnameVerifier = clientValidationStrategy.getHostnameVerifier()) != null) {
                            sslConnection.setHostnameVerifier(hostnameVerifier);
                        }
                    }
                } else if (!this.clientConfiguration.isUnsecuredConnectionAllowed()) {
                    throw new SSLException("Connection to non-TLS endpoint is not allowed.");
                }
                if (PA2Log.isEnabled()) {
                    String bodyStr = jsonRequestObject == null ? "<empty>" : jsonRequestObject;
                    Map<String, List<String>> prop = urlConnection.getRequestProperties();
                    String propStr = prop == null ? "<empty>" : prop.toString();
                    PA2Log.d("PA2Client %s request to URL: %s\n - Headers: %s\n - Body: %s", urlConnection.getRequestMethod(), url.toString(), propStr, bodyStr);
                }
                urlConnection.getOutputStream().write(postDataBytes);
                urlConnection.connect();
                int responseCode = urlConnection.getResponseCode();
                boolean responseOk = responseCode / 100 == 2;
                boolean tryParseJson = responseOk || responseCode == 400 || responseCode == 401;
                InputStream inputStream = responseOk ? urlConnection.getInputStream() : urlConnection.getErrorStream();
                String responseBody = PA2Client.this.loadStringFromInputStream(inputStream, urlConnection.getContentEncoding());
                if (PA2Log.isEnabled()) {
                    String bodyStr = responseBody == null ? "<empty body>" : responseBody;
                    Map<String, List<String>> prop = urlConnection.getHeaderFields();
                    String propStr = prop == null ? "<empty>" : prop.toString();
                    PA2Log.d("PA2Client response from URL: %s\n - Status code: %d\n - Headers: %s\n - Body: %s", url.toString(), responseCode, propStr, bodyStr);
                }
                String exceptionMessage = null;
                if (tryParseJson) {
                    try {
                        JsonObject jsonObject;
                        JsonElement jsonRoot = new JsonParser().parse(responseBody);
                        JsonObject jsonObject2 = jsonObject = jsonRoot.isJsonObject() ? jsonRoot.getAsJsonObject() : null;
                        if (jsonObject != null) {
                            JsonElement statusElement = jsonObject.get("status");
                            JsonElement responseElement = jsonObject.get("responseObject");
                            if (statusElement != null && statusElement.isJsonPrimitive()) {
                                if (statusElement.getAsString().equalsIgnoreCase("OK")) {
                                    if (this.requestDefinition.getResponseType() != null) {
                                        Object response = PA2Client.this.mGson.fromJson(responseElement, this.requestDefinition.getResponseType().getType());
                                        PA2Client.this.callOnResponseUi(response, this.responseListener);
                                    } else {
                                        PA2Client.this.callOnResponseUi(null, this.responseListener);
                                    }
                                } else {
                                    ErrorModel error = (ErrorModel)PA2Client.this.mGson.fromJson(responseElement, TypeToken.get(ErrorModel.class).getType());
                                    PA2Client.this.callOnErrorUi(new ErrorResponseApiException(error), this.responseListener);
                                }
                                return null;
                            }
                        }
                    }
                    catch (JsonParseException e) {
                        exceptionMessage = e.getMessage();
                    }
                }
                PA2Client.this.callOnErrorUi(new FailedApiException(exceptionMessage, responseCode, responseBody), this.responseListener);
            }
            catch (JsonParseException | IOException e) {
                PA2Client.this.callOnErrorUi(e, this.responseListener);
            }
            return null;
        }
    }
}

