/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk;

import android.app.FragmentManager;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.Base64;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.getlime.security.powerauth.core.ActivationStatus;
import io.getlime.security.powerauth.core.ActivationStep1Param;
import io.getlime.security.powerauth.core.ActivationStep1Result;
import io.getlime.security.powerauth.core.ActivationStep2Param;
import io.getlime.security.powerauth.core.ActivationStep2Result;
import io.getlime.security.powerauth.core.Password;
import io.getlime.security.powerauth.core.Session;
import io.getlime.security.powerauth.core.SessionSetup;
import io.getlime.security.powerauth.core.SignatureRequest;
import io.getlime.security.powerauth.core.SignatureResult;
import io.getlime.security.powerauth.core.SignatureUnlockKeys;
import io.getlime.security.powerauth.e2ee.PA2EncryptionFailedException;
import io.getlime.security.powerauth.e2ee.PA2EncryptorFactory;
import io.getlime.security.powerauth.e2ee.PA2RequestResponseNonPersonalizedEncryptor;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.exception.PowerAuthMissingConfigException;
import io.getlime.security.powerauth.keychain.PA2Keychain;
import io.getlime.security.powerauth.keychain.fingerprint.FingerprintAuthenticationDialogFragment;
import io.getlime.security.powerauth.keychain.fingerprint.FingerprintKeystore;
import io.getlime.security.powerauth.keychain.fingerprint.ICommitActivationWithFingerprintListener;
import io.getlime.security.powerauth.keychain.fingerprint.IFingerprintActionHandler;
import io.getlime.security.powerauth.networking.client.PA2Client;
import io.getlime.security.powerauth.networking.interfaces.INetworkResponseListener;
import io.getlime.security.powerauth.networking.response.IActivationRemoveListener;
import io.getlime.security.powerauth.networking.response.IActivationStatusListener;
import io.getlime.security.powerauth.networking.response.IAddBiometryFactorListener;
import io.getlime.security.powerauth.networking.response.IChangePasswordListener;
import io.getlime.security.powerauth.networking.response.ICreateActivationListener;
import io.getlime.security.powerauth.networking.response.IDataSignatureListener;
import io.getlime.security.powerauth.networking.response.IFetchEncryptionKeyListener;
import io.getlime.security.powerauth.networking.response.ISavePowerAuthStateListener;
import io.getlime.security.powerauth.networking.response.IValidatePasswordListener;
import io.getlime.security.powerauth.rest.api.model.base.PowerAuthApiRequest;
import io.getlime.security.powerauth.rest.api.model.base.PowerAuthApiResponse;
import io.getlime.security.powerauth.rest.api.model.entity.NonPersonalizedEncryptedPayloadModel;
import io.getlime.security.powerauth.rest.api.model.request.ActivationCreateCustomRequest;
import io.getlime.security.powerauth.rest.api.model.request.ActivationCreateRequest;
import io.getlime.security.powerauth.rest.api.model.request.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.response.ActivationCreateCustomResponse;
import io.getlime.security.powerauth.rest.api.model.response.ActivationCreateResponse;
import io.getlime.security.powerauth.rest.api.model.response.ActivationStatusResponse;
import io.getlime.security.powerauth.rest.api.model.response.VaultUnlockResponse;
import io.getlime.security.powerauth.sdk.PowerAuthAuthentication;
import io.getlime.security.powerauth.sdk.PowerAuthClientConfiguration;
import io.getlime.security.powerauth.sdk.PowerAuthConfiguration;
import io.getlime.security.powerauth.sdk.PowerAuthKeychainConfiguration;
import io.getlime.security.powerauth.sdk.impl.DefaultSavePowerAuthStateListener;
import io.getlime.security.powerauth.sdk.impl.PowerAuthAuthorizationHttpHeader;
import io.getlime.security.powerauth.util.otp.Otp;
import io.getlime.security.powerauth.util.otp.OtpUtil;
import java.util.HashMap;
import java.util.Map;

public class PowerAuthSDK {
    private Session mSession;
    private PowerAuthConfiguration mConfiguration;
    private PowerAuthClientConfiguration mClientConfiguration;
    private PowerAuthKeychainConfiguration mKeychainConfiguration;
    private PA2Client mClient;
    private ISavePowerAuthStateListener mStateListener;
    private PA2EncryptorFactory mEncryptorFactory;
    private PA2Keychain mStatusKeychain;
    private PA2Keychain mBiometryKeychain;

    private PowerAuthSDK() {
    }

    private void throwInvalidConfigurationException() {
        throw new PowerAuthMissingConfigException("Invalid PowerAuthSDK configuration. You must set a valid PowerAuthConfiguration to PowerAuthSDK instance using initializer.");
    }

    private void checkForValidSetup() {
        if (this.mSession == null || !this.mSession.hasValidSetup()) {
            this.throwInvalidConfigurationException();
        }
    }

    @CheckResult
    @Nullable
    private ActivationStep1Param paramStep1WithActivationCode(@NonNull String activationCode) {
        Otp otp = OtpUtil.parseFromActivationCode(activationCode);
        if (otp == null) {
            return null;
        }
        return new ActivationStep1Param(otp.getActivationIdShort(), otp.getActivationOtp(), otp.getActivationSignature());
    }

    private byte[] deviceRelatedKey(@NonNull Context context) {
        return this.mSession.normalizeSignatureUnlockKeyFromData(this.mConfiguration.getFetchKeysStrategy().getPossessionUnlockKey(context).getBytes());
    }

    private SignatureUnlockKeys signatureKeysForAuthentication(Context context, PowerAuthAuthentication authentication) {
        byte[] possessionKey = null;
        byte[] biometryKey = null;
        Password knowledgeKey = null;
        if (authentication.usePossession) {
            possessionKey = authentication.overridenPossessionKey != null ? authentication.overridenPossessionKey : this.deviceRelatedKey(context);
        }
        if (authentication.useBiometry != null) {
            biometryKey = authentication.useBiometry;
        }
        if (authentication.usePassword != null) {
            knowledgeKey = new Password(authentication.usePassword);
        }
        return new SignatureUnlockKeys(possessionKey, biometryKey, knowledgeKey);
    }

    private int determineSignatureFactorForAuthentication(PowerAuthAuthentication authentication) {
        if (authentication.usePossession && authentication.usePassword == null && authentication.useBiometry == null) {
            return 1;
        }
        if (!authentication.usePossession && authentication.usePassword != null && authentication.useBiometry == null) {
            return 16;
        }
        if (!authentication.usePossession && authentication.usePassword == null && authentication.useBiometry != null) {
            return 256;
        }
        if (authentication.usePossession && authentication.usePassword != null && authentication.useBiometry == null) {
            return 17;
        }
        if (authentication.usePossession && authentication.usePassword == null && authentication.useBiometry != null) {
            return 257;
        }
        if (authentication.usePossession && authentication.usePassword != null && authentication.useBiometry != null) {
            return 273;
        }
        return 273;
    }

    private int determineSignatureFactorForAuthentication(PowerAuthAuthentication authentication, boolean vaultUnlock) {
        if (vaultUnlock) {
            return this.determineSignatureFactorForAuthentication(authentication) + 4096;
        }
        return this.determineSignatureFactorForAuthentication(authentication);
    }

    @CheckResult
    @Nullable
    private AsyncTask fetchEncryptedVaultUnlockKey(@NonNull Context context, @NonNull PowerAuthAuthentication authentication, final @NonNull IFetchEncryptedVaultUnlockKeyListener listener) {
        this.checkForValidSetup();
        if (!this.mSession.hasValidActivation()) {
            listener.onFetchEncryptedVaultUnlockKeyFailed(new PowerAuthErrorException(5));
            return null;
        }
        PowerAuthAuthorizationHttpHeader httpHeader = this.requestSignatureWithAuthentication(context, authentication, true, "POST", "/pa/vault/unlock", null);
        if (httpHeader.getPowerAuthErrorCode() == 0) {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(httpHeader.getKey(), httpHeader.getValue());
            return this.mClient.vaultUnlockSignatureHeader(this.mConfiguration, this.mClientConfiguration, headers, new INetworkResponseListener<VaultUnlockResponse>(){

                @Override
                public void onNetworkResponse(VaultUnlockResponse vaultUnlockResponse) {
                    listener.onFetchEncryptedVaultUnlockKeySucceed(vaultUnlockResponse.getEncryptedVaultEncryptionKey());
                }

                @Override
                public void onNetworkError(Throwable t) {
                    listener.onFetchEncryptedVaultUnlockKeyFailed(t);
                }
            });
        }
        listener.onFetchEncryptedVaultUnlockKeyFailed(new PowerAuthErrorException(httpHeader.getPowerAuthErrorCode()));
        return null;
    }

    public Session getSession() {
        return this.mSession;
    }

    public PA2EncryptorFactory getEncryptorFactory() {
        return this.mEncryptorFactory;
    }

    public void saveSerializedState() {
        byte[] state = this.mSession.serializedState();
        this.mStateListener.onPowerAuthStateChanged(this.mConfiguration.getInstanceId(), state);
    }

    @CheckResult
    public boolean restoreState(byte[] state) {
        this.mSession.resetSession();
        int result = this.mSession.deserializeState(state);
        return result == 0;
    }

    @CheckResult
    public boolean hasDebugFeatures() {
        return this.mSession.hasDebugFeatures();
    }

    @CheckResult
    public boolean canStartActivation() {
        this.checkForValidSetup();
        return this.mSession.canStartActivation();
    }

    @CheckResult
    public boolean hasPendingActivation() {
        this.checkForValidSetup();
        return this.mSession.hasPendingActivation();
    }

    @CheckResult
    public boolean hasValidActivation() {
        this.checkForValidSetup();
        return this.mSession.hasValidActivation();
    }

    public void destroy() {
        this.mSession.destroy();
        this.mSession = null;
    }

    @Nullable
    public AsyncTask createActivation(@Nullable String name, @NonNull String activationCode, @NonNull ICreateActivationListener listener) {
        return this.createActivation(name, activationCode, null, listener);
    }

    @Nullable
    public AsyncTask createActivation(@Nullable String name, @NonNull String activationCode, @Nullable String extras, final @NonNull ICreateActivationListener listener) {
        if (!this.canStartActivation()) {
            listener.onActivationCreateFailed(new PowerAuthErrorException(3));
            return null;
        }
        this.removeActivationLocal(null, false);
        ActivationStep1Param paramStep1 = this.paramStep1WithActivationCode(activationCode);
        if (paramStep1 == null) {
            listener.onActivationCreateFailed(new PowerAuthErrorException(12));
            return null;
        }
        ActivationStep1Result step1Result = this.mSession.startActivation(paramStep1);
        if (step1Result.errorCode != 0) {
            int errorCode = step1Result.errorCode == 1 ? 2 : 4;
            listener.onActivationCreateFailed(new PowerAuthErrorException(errorCode));
            return null;
        }
        ActivationCreateRequest request = new ActivationCreateRequest();
        request.setActivationIdShort(paramStep1.activationIdShort);
        request.setActivationName(name);
        request.setActivationNonce(step1Result.activationNonce);
        request.setApplicationKey(this.mConfiguration.getAppKey());
        request.setApplicationSignature(step1Result.applicationSignature);
        request.setEncryptedDevicePublicKey(step1Result.cDevicePublicKey);
        request.setEphemeralPublicKey(step1Result.ephemeralPublicKey);
        request.setExtras(extras);
        return this.mClient.createActivation(this.mConfiguration, this.mClientConfiguration, request, new INetworkResponseListener<ActivationCreateResponse>(){

            @Override
            public void onNetworkResponse(ActivationCreateResponse response) {
                ActivationStep2Param paramStep2 = new ActivationStep2Param(response.getActivationId(), response.getActivationNonce(), response.getEphemeralPublicKey(), response.getEncryptedServerPublicKey(), response.getEncryptedServerPublicKeySignature());
                ActivationStep2Result resultStep2 = PowerAuthSDK.this.mSession.validateActivationResponse(paramStep2);
                if (resultStep2.errorCode == 0) {
                    listener.onActivationCreateSucceed(resultStep2.hkDevicePublicKey);
                } else {
                    PowerAuthSDK.this.mSession.resetSession();
                    listener.onActivationCreateFailed(new PowerAuthErrorException(4));
                }
            }

            @Override
            public void onNetworkError(Throwable t) {
                PowerAuthSDK.this.mSession.resetSession();
                listener.onActivationCreateFailed(t);
            }
        });
    }

    @Nullable
    public AsyncTask createActivation(@Nullable String name, @NonNull Map<String, String> identityAttributes, @NonNull String customSecret, @Nullable String extras, @Nullable Map<String, Object> customAttributes, @NonNull String url, @Nullable Map<String, String> httpHeaders, final @NonNull ICreateActivationListener listener) {
        if (!this.canStartActivation()) {
            listener.onActivationCreateFailed(new PowerAuthErrorException(3));
            return null;
        }
        this.removeActivationLocal(null, false);
        byte[] identityAttributesBytes = this.mSession.prepareKeyValueDictionaryForDataSigning(identityAttributes);
        String identityAttributesString = Base64.encodeToString((byte[])identityAttributesBytes, (int)0);
        ActivationStep1Param paramStep1 = new ActivationStep1Param(identityAttributesString, customSecret, null);
        ActivationStep1Result resultStep1 = this.mSession.startActivation(paramStep1);
        if (resultStep1.errorCode != 0) {
            int errorCode = resultStep1.errorCode == 1 ? 2 : 4;
            listener.onActivationCreateFailed(new PowerAuthErrorException(errorCode));
            return null;
        }
        ActivationCreateRequest powerauth = new ActivationCreateRequest();
        powerauth.setActivationIdShort(paramStep1.activationIdShort);
        powerauth.setActivationName(name);
        powerauth.setActivationNonce(resultStep1.activationNonce);
        powerauth.setApplicationKey(this.mConfiguration.getAppKey());
        powerauth.setApplicationSignature(resultStep1.applicationSignature);
        powerauth.setEncryptedDevicePublicKey(resultStep1.cDevicePublicKey);
        powerauth.setEphemeralPublicKey(resultStep1.ephemeralPublicKey);
        powerauth.setExtras(extras);
        ActivationCreateCustomRequest request = new ActivationCreateCustomRequest();
        request.setIdentity(identityAttributes);
        request.setCustomAttributes(customAttributes);
        request.setPowerauth(powerauth);
        final Gson gson = new GsonBuilder().create();
        String requestDataString = gson.toJson((Object)request);
        if (requestDataString == null) {
            this.mSession.resetSession();
            listener.onActivationCreateFailed(new PA2EncryptionFailedException());
            return null;
        }
        byte[] requestData = requestDataString.getBytes();
        final PA2RequestResponseNonPersonalizedEncryptor encryptor = this.mEncryptorFactory.buildRequestResponseNonPersonalizedEncryptor();
        PowerAuthApiRequest<NonPersonalizedEncryptedPayloadModel> encryptedRequest = null;
        try {
            encryptedRequest = encryptor.encryptRequestData(requestData);
        }
        catch (PA2EncryptionFailedException e) {
            this.mSession.resetSession();
            listener.onActivationCreateFailed(e);
            return null;
        }
        return this.mClient.sendNonPersonalizedEncryptedObjectToUrl(this.mConfiguration, this.mClientConfiguration, (NonPersonalizedEncryptedPayloadModel)encryptedRequest.getRequestObject(), url, httpHeaders, new INetworkResponseListener<NonPersonalizedEncryptedPayloadModel>(){

            @Override
            public void onNetworkResponse(NonPersonalizedEncryptedPayloadModel nonPersonalizedEncryptedPayloadModel) {
                try {
                    byte[] originalBytes = encryptor.decryptResponse((PowerAuthApiResponse<NonPersonalizedEncryptedPayloadModel>)new PowerAuthApiResponse("OK", "nonpersonalized", (Object)nonPersonalizedEncryptedPayloadModel));
                    ActivationCreateCustomResponse activationCreateResponse = (ActivationCreateCustomResponse)gson.fromJson(new String(originalBytes), ActivationCreateCustomResponse.class);
                    ActivationStep2Param step2Param = new ActivationStep2Param(activationCreateResponse.getActivationId(), activationCreateResponse.getActivationNonce(), activationCreateResponse.getEphemeralPublicKey(), activationCreateResponse.getEncryptedServerPublicKey(), activationCreateResponse.getEncryptedServerPublicKeySignature());
                    ActivationStep2Result step2Result = PowerAuthSDK.this.mSession.validateActivationResponse(step2Param);
                    if (step2Result != null && step2Result.errorCode == 0) {
                        listener.onActivationCreateSucceed(step2Result.hkDevicePublicKey);
                    } else {
                        PowerAuthSDK.this.mSession.resetSession();
                        listener.onActivationCreateFailed(new PowerAuthErrorException(4));
                    }
                }
                catch (PA2EncryptionFailedException e) {
                    PowerAuthSDK.this.mSession.resetSession();
                    listener.onActivationCreateFailed(e);
                }
            }

            @Override
            public void onNetworkError(Throwable t) {
                PowerAuthSDK.this.mSession.resetSession();
                listener.onActivationCreateFailed(t);
            }
        });
    }

    public AsyncTask createActivation(String name, Map<String, String> identityAttributes, String url, ICreateActivationListener listener) {
        return this.createActivation(name, identityAttributes, "00000-00000", null, null, url, null, listener);
    }

    @CheckResult
    public int commitActivationWithPassword(@NonNull Context context, @NonNull String password) {
        PowerAuthAuthentication authentication = new PowerAuthAuthentication();
        authentication.useBiometry = null;
        authentication.usePossession = true;
        authentication.usePassword = password;
        return this.commitActivationWithAuthentication(context, authentication);
    }

    @RequiresApi(api=23)
    public void commitActivation(final @NonNull Context context, FragmentManager fragmentManager, String title, String description, final @NonNull String password, final ICommitActivationWithFingerprintListener callback) {
        this.authenticateUsingFingerprint(context, fragmentManager, title, description, true, new IFingerprintActionHandler(){

            @Override
            public void onFingerprintDialogCancelled() {
                callback.onFingerprintDialogCancelled();
            }

            @Override
            public void onFingerprintDialogSuccess(@Nullable byte[] biometricKeyEncrypted) {
                int b = PowerAuthSDK.this.commitActivationWithPassword(context, password, biometricKeyEncrypted);
                callback.onFingerprintDialogSuccess();
            }

            @Override
            public void onFingerprintInfoDialogClosed() {
                callback.onFingerprintDialogCancelled();
            }
        });
    }

    @RequiresApi(api=23)
    @CheckResult
    public int commitActivationWithPassword(@NonNull Context context, @NonNull String password, @Nullable byte[] encryptedBiometryKey) {
        PowerAuthAuthentication authentication = new PowerAuthAuthentication();
        authentication.useBiometry = encryptedBiometryKey;
        authentication.usePossession = true;
        authentication.usePassword = password;
        return this.commitActivationWithAuthentication(context, authentication);
    }

    @CheckResult
    public int commitActivationWithAuthentication(@NonNull Context context, @NonNull PowerAuthAuthentication authentication) {
        Password knowledgeKey;
        byte[] biometryKey;
        this.checkForValidSetup();
        if (!this.mSession.hasPendingActivation()) {
            return 3;
        }
        byte[] possessionKey = authentication.usePossession ? this.deviceRelatedKey(context) : null;
        SignatureUnlockKeys keys = new SignatureUnlockKeys(possessionKey, biometryKey = authentication.useBiometry, knowledgeKey = authentication.usePassword != null ? new Password(authentication.usePassword) : null);
        int result = this.mSession.completeActivation(keys);
        if (result == 0) {
            this.saveSerializedState();
            return 0;
        }
        return 3;
    }

    @Nullable
    public AsyncTask fetchActivationStatusWithCallback(final @NonNull Context context, final @NonNull IActivationStatusListener listener) {
        this.checkForValidSetup();
        if (!this.mSession.hasValidActivation()) {
            int errorCode = this.mSession.hasPendingActivation() ? 7 : 5;
            listener.onActivationStatusFailed(new PowerAuthErrorException(errorCode));
            return null;
        }
        ActivationStatusRequest request = new ActivationStatusRequest();
        request.setActivationId(this.mSession.getActivationIdentifier());
        return this.mClient.getActivationStatus(this.mConfiguration, this.mClientConfiguration, request, new INetworkResponseListener<ActivationStatusResponse>(){

            @Override
            public void onNetworkResponse(ActivationStatusResponse activationStatusResponse) {
                SignatureUnlockKeys keys = new SignatureUnlockKeys(PowerAuthSDK.this.deviceRelatedKey(context), null, null);
                ActivationStatus activationStatus = PowerAuthSDK.this.mSession.decodeActivationStatus(activationStatusResponse.getEncryptedStatusBlob(), keys);
                if (activationStatus != null) {
                    listener.onActivationStatusSucceed(activationStatus);
                } else {
                    listener.onActivationStatusFailed(new PowerAuthErrorException(4));
                }
            }

            @Override
            public void onNetworkError(Throwable t) {
                listener.onActivationStatusFailed(t);
            }
        });
    }

    @Nullable
    public AsyncTask removeActivationWithAuthentication(final @NonNull Context context, @NonNull PowerAuthAuthentication authentication, final @NonNull IActivationRemoveListener listener) {
        this.checkForValidSetup();
        if (!this.mSession.hasValidActivation()) {
            listener.onActivationRemoveFailed(new PowerAuthErrorException(5));
            return null;
        }
        PowerAuthAuthorizationHttpHeader httpHeader = this.requestSignatureWithAuthentication(context, authentication, "POST", "/pa/activation/remove", null);
        if (httpHeader.getPowerAuthErrorCode() != 0) {
            listener.onActivationRemoveFailed(new PowerAuthErrorException(httpHeader.getPowerAuthErrorCode()));
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(httpHeader.getKey(), httpHeader.getValue());
        return this.mClient.removeActivationSignatureHeader(this.mConfiguration, this.mClientConfiguration, headers, new INetworkResponseListener<Void>(){

            @Override
            public void onNetworkResponse(Void aVoid) {
                PowerAuthSDK.this.removeActivationLocal(context);
                listener.onActivationRemoveSucceed();
            }

            @Override
            public void onNetworkError(Throwable t) {
                listener.onActivationRemoveFailed(t);
            }
        });
    }

    public void removeActivationLocal(@NonNull Context context) {
        this.removeActivationLocal(context, true);
    }

    public void removeActivationLocal(@Nullable Context context, boolean removeSharedBiometryKey) {
        this.checkForValidSetup();
        if (Build.VERSION.SDK_INT >= 23 && removeSharedBiometryKey && this.mSession.hasBiometryFactor() && context != null) {
            this.mBiometryKeychain.removeDataForKey(context, this.mKeychainConfiguration.getKeychainBiometryDefaultKey());
            FingerprintKeystore keyStore = new FingerprintKeystore();
            if (keyStore.isKeystoreReady()) {
                keyStore.removeDefaultKey();
            }
        }
        this.mSession.resetSession();
        this.saveSerializedState();
    }

    public PowerAuthAuthorizationHttpHeader requestGetSignatureWithAuthentication(@NonNull Context context, @NonNull PowerAuthAuthentication authentication, String uriId, Map<String, String> params) {
        byte[] body = this.mSession.prepareKeyValueDictionaryForDataSigning(params);
        return this.requestSignatureWithAuthentication(context, authentication, false, "GET", uriId, body);
    }

    public PowerAuthAuthorizationHttpHeader requestSignatureWithAuthentication(@NonNull Context context, @NonNull PowerAuthAuthentication authentication, String method, String uriId, byte[] body) {
        return this.requestSignatureWithAuthentication(context, authentication, false, method, uriId, body);
    }

    public PowerAuthAuthorizationHttpHeader requestSignatureWithAuthentication(@NonNull Context context, @NonNull PowerAuthAuthentication authentication, boolean vaultUnlock, String method, String uriId, byte[] body) {
        this.checkForValidSetup();
        if (!this.mSession.hasValidActivation()) {
            return new PowerAuthAuthorizationHttpHeader(null, 5);
        }
        SignatureUnlockKeys keys = this.signatureKeysForAuthentication(context, authentication);
        if (keys == null) {
            return new PowerAuthAuthorizationHttpHeader(null, 4);
        }
        int signatureFactor = this.determineSignatureFactorForAuthentication(authentication, vaultUnlock);
        SignatureRequest signatureRequest = new SignatureRequest(body, method, uriId, null);
        SignatureResult signatureResult = this.mSession.signHTTPRequest(signatureRequest, keys, signatureFactor);
        this.saveSerializedState();
        if (signatureResult.errorCode == 0) {
            return new PowerAuthAuthorizationHttpHeader(signatureResult.authHeaderValue, 0);
        }
        return new PowerAuthAuthorizationHttpHeader(null, 2);
    }

    public String offlineSignatureWithAuthentication(@NonNull Context context, @NonNull PowerAuthAuthentication authentication, String method, String uriId, byte[] body, String nonce) {
        this.checkForValidSetup();
        if (!this.mSession.hasValidActivation()) {
            return null;
        }
        SignatureUnlockKeys keys = this.signatureKeysForAuthentication(context, authentication);
        if (keys == null) {
            return null;
        }
        if (nonce == null) {
            return null;
        }
        int signatureFactor = this.determineSignatureFactorForAuthentication(authentication, false);
        SignatureRequest signatureRequest = new SignatureRequest(body, method, uriId, nonce);
        SignatureResult signatureResult = this.mSession.signHTTPRequest(signatureRequest, keys, signatureFactor);
        this.saveSerializedState();
        if (signatureResult.errorCode == 0) {
            return signatureResult.signatureCode;
        }
        return null;
    }

    public AsyncTask signDataWithDevicePrivateKey(final @NonNull Context context, @NonNull PowerAuthAuthentication authentication, final @NonNull byte[] data, final @NonNull IDataSignatureListener listener) {
        return this.fetchEncryptedVaultUnlockKey(context, authentication, new IFetchEncryptedVaultUnlockKeyListener(){

            @Override
            public void onFetchEncryptedVaultUnlockKeySucceed(String encryptedEncryptionKey) {
                if (encryptedEncryptionKey != null) {
                    SignatureUnlockKeys keys = new SignatureUnlockKeys(PowerAuthSDK.this.deviceRelatedKey(context), null, null);
                    byte[] signature = PowerAuthSDK.this.mSession.signDataWithDevicePrivateKey(encryptedEncryptionKey, keys, data);
                    if (signature != null) {
                        listener.onDataSignedSucceed(signature);
                    } else {
                        listener.onDataSignedFailed(new PowerAuthErrorException(4));
                    }
                } else {
                    listener.onDataSignedFailed(new PowerAuthErrorException(3));
                }
            }

            @Override
            public void onFetchEncryptedVaultUnlockKeyFailed(Throwable t) {
                listener.onDataSignedFailed(t);
            }
        });
    }

    public boolean changePasswordUnsafe(@NonNull String oldPassword, @NonNull String newPassword) {
        int result = this.mSession.changeUserPassword(new Password(oldPassword), new Password(newPassword));
        if (result == 0) {
            this.saveSerializedState();
            return true;
        }
        return false;
    }

    public AsyncTask changePassword(@NonNull Context context, final @NonNull String oldPassword, final @NonNull String newPassword, final @NonNull IChangePasswordListener listener) {
        PowerAuthAuthentication authentication = new PowerAuthAuthentication();
        authentication.usePossession = true;
        authentication.usePassword = oldPassword;
        return this.fetchEncryptedVaultUnlockKey(context, authentication, new IFetchEncryptedVaultUnlockKeyListener(){

            @Override
            public void onFetchEncryptedVaultUnlockKeySucceed(String encryptedEncryptionKey) {
                int result = PowerAuthSDK.this.mSession.changeUserPassword(new Password(oldPassword), new Password(newPassword));
                if (result == 0) {
                    PowerAuthSDK.this.saveSerializedState();
                    listener.onPasswordChangeSucceed();
                } else {
                    listener.onPasswordChangeFailed(new PowerAuthErrorException(3));
                }
            }

            @Override
            public void onFetchEncryptedVaultUnlockKeyFailed(Throwable t) {
                listener.onPasswordChangeFailed(t);
            }
        });
    }

    @RequiresApi(api=23)
    public boolean hasBiometryFactor(@NonNull Context context) {
        this.checkForValidSetup();
        FingerprintKeystore keyStore = new FingerprintKeystore();
        if (!keyStore.isKeystoreReady()) {
            return false;
        }
        return this.mSession.hasBiometryFactor() && this.mBiometryKeychain.containsDataForKey(context, this.mKeychainConfiguration.getKeychainBiometryDefaultKey()) && keyStore.containsDefaultKey();
    }

    @RequiresApi(api=23)
    @Nullable
    public AsyncTask addBiometryFactor(final @NonNull Context context, final FragmentManager fragmentManager, final String title, final String description, String password, final @NonNull IAddBiometryFactorListener listener) {
        PowerAuthAuthentication authAuthentication = new PowerAuthAuthentication();
        authAuthentication.usePossession = true;
        authAuthentication.usePassword = password;
        return this.fetchEncryptedVaultUnlockKey(context, authAuthentication, new IFetchEncryptedVaultUnlockKeyListener(){

            @Override
            public void onFetchEncryptedVaultUnlockKeySucceed(final String encryptedEncryptionKey) {
                if (encryptedEncryptionKey != null) {
                    PowerAuthSDK.this.authenticateUsingFingerprint(context, fragmentManager, title, description, true, new IFingerprintActionHandler(){

                        @Override
                        public void onFingerprintDialogCancelled() {
                            listener.onAddBiometryFactorFailed(new PowerAuthErrorException(10));
                        }

                        @Override
                        public void onFingerprintDialogSuccess(@Nullable byte[] biometricKeyEncrypted) {
                            SignatureUnlockKeys keys = new SignatureUnlockKeys(PowerAuthSDK.this.deviceRelatedKey(context), biometricKeyEncrypted, null);
                            int result = PowerAuthSDK.this.mSession.addBiometryFactor(encryptedEncryptionKey, keys);
                            if (result == 0) {
                                PowerAuthSDK.this.saveSerializedState();
                                listener.onAddBiometryFactorSucceed();
                            } else {
                                listener.onAddBiometryFactorFailed(new PowerAuthErrorException(3));
                            }
                        }

                        @Override
                        public void onFingerprintInfoDialogClosed() {
                            listener.onAddBiometryFactorFailed(new PowerAuthErrorException(10));
                        }
                    });
                } else {
                    listener.onAddBiometryFactorFailed(new PowerAuthErrorException(4));
                }
            }

            @Override
            public void onFetchEncryptedVaultUnlockKeyFailed(Throwable t) {
                listener.onAddBiometryFactorFailed(t);
            }
        });
    }

    @Nullable
    public AsyncTask addBiometryFactor(final @NonNull Context context, String password, final byte[] encryptedBiometryKey, final @NonNull IAddBiometryFactorListener listener) {
        PowerAuthAuthentication authAuthentication = new PowerAuthAuthentication();
        authAuthentication.usePossession = true;
        authAuthentication.usePassword = password;
        return this.fetchEncryptedVaultUnlockKey(context, authAuthentication, new IFetchEncryptedVaultUnlockKeyListener(){

            @Override
            public void onFetchEncryptedVaultUnlockKeySucceed(String encryptedEncryptionKey) {
                if (encryptedEncryptionKey != null) {
                    SignatureUnlockKeys keys = new SignatureUnlockKeys(PowerAuthSDK.this.deviceRelatedKey(context), encryptedBiometryKey, null);
                    int result = PowerAuthSDK.this.mSession.addBiometryFactor(encryptedEncryptionKey, keys);
                    if (result == 0) {
                        PowerAuthSDK.this.saveSerializedState();
                        listener.onAddBiometryFactorSucceed();
                    } else {
                        listener.onAddBiometryFactorFailed(new PowerAuthErrorException(3));
                    }
                } else {
                    listener.onAddBiometryFactorFailed(new PowerAuthErrorException(3));
                }
            }

            @Override
            public void onFetchEncryptedVaultUnlockKeyFailed(Throwable t) {
                listener.onAddBiometryFactorFailed(t);
            }
        });
    }

    @RequiresApi(api=23)
    public boolean removeBiometryFactor(@NonNull Context context) {
        this.checkForValidSetup();
        int result = this.mSession.removeBiometryFactor();
        if (result == 0) {
            this.saveSerializedState();
            this.mBiometryKeychain.removeDataForKey(context, this.mKeychainConfiguration.getKeychainBiometryDefaultKey());
            FingerprintKeystore keyStore = new FingerprintKeystore();
            if (keyStore.isKeystoreReady()) {
                keyStore.removeDefaultKey();
            }
        }
        return result == 0;
    }

    @Nullable
    public AsyncTask fetchEncryptionKey(final @NonNull Context context, @NonNull PowerAuthAuthentication authentication, final long index, final @NonNull IFetchEncryptionKeyListener listener) {
        return this.fetchEncryptedVaultUnlockKey(context, authentication, new IFetchEncryptedVaultUnlockKeyListener(){

            @Override
            public void onFetchEncryptedVaultUnlockKeySucceed(String encryptedEncryptionKey) {
                SignatureUnlockKeys keys = new SignatureUnlockKeys(PowerAuthSDK.this.deviceRelatedKey(context), null, null);
                byte[] key = PowerAuthSDK.this.mSession.deriveCryptographicKeyFromVaultKey(encryptedEncryptionKey, keys, index);
                if (key != null) {
                    listener.onFetchEncryptionKeySucceed(key);
                } else {
                    listener.onFetchEncryptionKeyFailed(new PowerAuthErrorException(4));
                }
            }

            @Override
            public void onFetchEncryptedVaultUnlockKeyFailed(Throwable t) {
                listener.onFetchEncryptionKeyFailed(t);
            }
        });
    }

    @Nullable
    public AsyncTask validatePasswordCorrect(@NonNull Context context, String password, final @NonNull IValidatePasswordListener listener) {
        PowerAuthAuthentication authentication = new PowerAuthAuthentication();
        authentication.usePossession = true;
        authentication.usePassword = password;
        return this.fetchEncryptedVaultUnlockKey(context, authentication, new IFetchEncryptedVaultUnlockKeyListener(){

            @Override
            public void onFetchEncryptedVaultUnlockKeySucceed(String encryptedEncryptionKey) {
                listener.onPasswordValid();
            }

            @Override
            public void onFetchEncryptedVaultUnlockKeyFailed(Throwable t) {
                listener.onPasswordValidationFailed(t);
            }
        });
    }

    @RequiresApi(api=23)
    public void authenticateUsingFingerprint(Context context, FragmentManager fragmentManager, String title, String description, IFingerprintActionHandler callback) {
        this.authenticateUsingFingerprint(context, fragmentManager, title, description, false, callback);
    }

    @RequiresApi(api=23)
    private void authenticateUsingFingerprint(final @NonNull Context context, @NonNull FragmentManager fragmentManager, @NonNull String title, @NonNull String description, final boolean forceGenerateNewKey, final IFingerprintActionHandler callback) {
        final byte[] biometryKey = forceGenerateNewKey ? this.mSession.generateSignatureUnlockKey() : this.mBiometryKeychain.dataForKey(context, this.mKeychainConfiguration.getKeychainBiometryDefaultKey());
        FingerprintAuthenticationDialogFragment dialog = new FingerprintAuthenticationDialogFragment.DialogFragmentBuilder().title(title).description(description).biometricKey(biometryKey).forceGenerateNewKey(forceGenerateNewKey).build();
        dialog.setFragmentManager(fragmentManager);
        dialog.setAuthenticationCallback(new IFingerprintActionHandler(){

            @Override
            public void onFingerprintDialogCancelled() {
                callback.onFingerprintDialogCancelled();
            }

            @Override
            public void onFingerprintDialogSuccess(@Nullable byte[] biometricKeyEncrypted) {
                if (forceGenerateNewKey) {
                    PowerAuthSDK.this.mBiometryKeychain.putDataForKey(context, biometryKey, PowerAuthSDK.this.mKeychainConfiguration.getKeychainBiometryDefaultKey());
                }
                byte[] normalizedEncryptionKey = PowerAuthSDK.this.mSession.normalizeSignatureUnlockKeyFromData(biometricKeyEncrypted);
                callback.onFingerprintDialogSuccess(normalizedEncryptionKey);
            }

            @Override
            public void onFingerprintInfoDialogClosed() {
                callback.onFingerprintInfoDialogClosed();
            }
        });
        dialog.show();
    }

    private static interface IFetchEncryptedVaultUnlockKeyListener {
        public void onFetchEncryptedVaultUnlockKeySucceed(String var1);

        public void onFetchEncryptedVaultUnlockKeyFailed(Throwable var1);
    }

    public static class Builder {
        private PowerAuthConfiguration mConfiguration;
        private PowerAuthClientConfiguration mClientConfiguration;
        private PowerAuthKeychainConfiguration mKeychainConfiguration;
        private ISavePowerAuthStateListener mStateListener;

        public Builder(@NonNull PowerAuthConfiguration mConfiguration) {
            this.mConfiguration = mConfiguration;
        }

        public Builder clientConfiguration(PowerAuthClientConfiguration configuration) {
            this.mClientConfiguration = configuration;
            return this;
        }

        public Builder keychainConfiguration(PowerAuthKeychainConfiguration configuration) {
            this.mKeychainConfiguration = configuration;
            return this;
        }

        public Builder stateListener(ISavePowerAuthStateListener stateListener) {
            this.mStateListener = stateListener;
            return this;
        }

        public PowerAuthSDK build(@NonNull Context context) {
            PowerAuthSDK instance = new PowerAuthSDK();
            instance.mConfiguration = this.mConfiguration;
            if (this.mKeychainConfiguration != null) {
                instance.mKeychainConfiguration = this.mKeychainConfiguration;
            } else {
                instance.mKeychainConfiguration = new PowerAuthKeychainConfiguration();
            }
            if (this.mClientConfiguration != null) {
                instance.mClientConfiguration = this.mClientConfiguration;
            } else {
                instance.mClientConfiguration = new PowerAuthClientConfiguration.Builder().build();
            }
            instance.mClient = new PA2Client();
            instance.mStatusKeychain = new PA2Keychain(instance.mKeychainConfiguration.getKeychainStatusId());
            instance.mBiometryKeychain = new PA2Keychain(instance.mKeychainConfiguration.getKeychainBiometryId());
            if (this.mStateListener != null) {
                instance.mStateListener = this.mStateListener;
            } else {
                instance.mStateListener = new DefaultSavePowerAuthStateListener(context, instance.mStatusKeychain);
            }
            SessionSetup sessionSetup = new SessionSetup(this.mConfiguration.getAppKey(), this.mConfiguration.getAppSecret(), this.mConfiguration.getMasterServerPublicKey(), 0, this.mConfiguration.getExternalEncryptionKey());
            instance.mSession = new Session(sessionSetup);
            instance.mEncryptorFactory = new PA2EncryptorFactory(instance.mSession);
            boolean b = instance.restoreState(instance.mStateListener.serializedState(instance.mConfiguration.getInstanceId()));
            return instance;
        }
    }
}

