/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk;

import io.getlime.security.powerauth.networking.ssl.PA2ClientValidationStrategy;

public class PowerAuthClientConfiguration {
    private static final int DEF_CONNECTION_TIMEOUT = 20000;
    private static final int DEF_READ_TIMEOUT = 20000;
    private int connectionTimeout = 20000;
    private int readTimeout = 20000;
    private PA2ClientValidationStrategy clientValidationStrategy;

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public PA2ClientValidationStrategy getClientValidationStrategy() {
        return this.clientValidationStrategy;
    }

    public static class Builder {
        private int connectionTimeout = 20000;
        private int readTimeout = 20000;
        private PA2ClientValidationStrategy clientValidationStrategy;

        public Builder timeouts(int connectionTimeout, int readTimeout) {
            this.connectionTimeout = connectionTimeout;
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder clientValidationStrategy(PA2ClientValidationStrategy clientValidationStrategy) {
            this.clientValidationStrategy = clientValidationStrategy;
            return this;
        }

        public PowerAuthClientConfiguration build() {
            PowerAuthClientConfiguration powerAuthClientConfiguration = new PowerAuthClientConfiguration();
            powerAuthClientConfiguration.connectionTimeout = this.connectionTimeout;
            powerAuthClientConfiguration.readTimeout = this.readTimeout;
            powerAuthClientConfiguration.clientValidationStrategy = this.clientValidationStrategy;
            return powerAuthClientConfiguration;
        }
    }
}

