/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.networking.client;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import io.getlime.security.powerauth.networking.endpoints.PA2ActivationStatusEndpoint;
import io.getlime.security.powerauth.networking.endpoints.PA2CreateActivationEndpoint;
import io.getlime.security.powerauth.networking.endpoints.PA2NonPersonalizedEncryptedEndpoint;
import io.getlime.security.powerauth.networking.endpoints.PA2RemoveActivationEndpoint;
import io.getlime.security.powerauth.networking.endpoints.PA2VaultUnlockEndpoint;
import io.getlime.security.powerauth.networking.exceptions.ErrorResponseApiException;
import io.getlime.security.powerauth.networking.exceptions.FailedApiException;
import io.getlime.security.powerauth.networking.interfaces.IEndpointDefinition;
import io.getlime.security.powerauth.networking.interfaces.INetworkResponseListener;
import io.getlime.security.powerauth.networking.ssl.PA2ClientValidationStrategy;
import io.getlime.security.powerauth.rest.api.model.base.PowerAuthApiRequest;
import io.getlime.security.powerauth.rest.api.model.entity.ErrorModel;
import io.getlime.security.powerauth.rest.api.model.entity.NonPersonalizedEncryptedPayloadModel;
import io.getlime.security.powerauth.rest.api.model.request.ActivationCreateRequest;
import io.getlime.security.powerauth.rest.api.model.request.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.response.ActivationCreateResponse;
import io.getlime.security.powerauth.rest.api.model.response.ActivationStatusResponse;
import io.getlime.security.powerauth.rest.api.model.response.VaultUnlockResponse;
import io.getlime.security.powerauth.sdk.PowerAuthClientConfiguration;
import io.getlime.security.powerauth.sdk.PowerAuthConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class PA2Client {
    private final Gson mGson = new GsonBuilder().create();
    private final Handler mHandler = new Handler(Looper.getMainLooper());

    private <TResponse> void callOnResponseUi(final TResponse response, final INetworkResponseListener<TResponse> responseListener) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                responseListener.onNetworkResponse(response);
            }
        });
    }

    private <TResponse> void callOnErrorUi(final Throwable t, final INetworkResponseListener<TResponse> responseListener) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                responseListener.onNetworkError(t);
            }
        });
    }

    private <TRequest, TResponse> AsyncTask execute(@NonNull PowerAuthConfiguration configuration, @NonNull PowerAuthClientConfiguration clientConfiguration, @NonNull IEndpointDefinition<TResponse> requestDefinition, @Nullable TRequest requestBody, @Nullable Map<String, String> headers, @NonNull INetworkResponseListener<TResponse> responseListener) {
        RestExecutor restExecutor = new RestExecutor(clientConfiguration, headers, requestDefinition, responseListener);
        return restExecutor.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Object[]{requestBody, null, null});
    }

    @CheckResult
    public AsyncTask sendNonPersonalizedEncryptedObjectToUrl(@NonNull PowerAuthConfiguration configuration, @NonNull PowerAuthClientConfiguration clientConfiguration, @NonNull NonPersonalizedEncryptedPayloadModel request, @NonNull String url, @NonNull Map<String, String> headers, @NonNull INetworkResponseListener<NonPersonalizedEncryptedPayloadModel> listener) {
        return this.execute(configuration, clientConfiguration, new PA2NonPersonalizedEncryptedEndpoint(url), request, headers, listener);
    }

    @CheckResult
    public AsyncTask createActivation(@NonNull PowerAuthConfiguration configuration, @NonNull PowerAuthClientConfiguration clientConfiguration, @NonNull ActivationCreateRequest request, @NonNull INetworkResponseListener<ActivationCreateResponse> listener) {
        return this.execute(configuration, clientConfiguration, new PA2CreateActivationEndpoint(configuration.getBaseEndpointUrl()), request, null, listener);
    }

    @CheckResult
    public AsyncTask getActivationStatus(@NonNull PowerAuthConfiguration configuration, @NonNull PowerAuthClientConfiguration clientConfiguration, @NonNull ActivationStatusRequest request, @NonNull INetworkResponseListener<ActivationStatusResponse> listener) {
        return this.execute(configuration, clientConfiguration, new PA2ActivationStatusEndpoint(configuration.getBaseEndpointUrl()), request, null, listener);
    }

    @CheckResult
    public AsyncTask removeActivationSignatureHeader(@NonNull PowerAuthConfiguration configuration, @NonNull PowerAuthClientConfiguration clientConfiguration, @NonNull Map<String, String> headers, @NonNull INetworkResponseListener<Void> listener) {
        return this.execute(configuration, clientConfiguration, new PA2RemoveActivationEndpoint(configuration.getBaseEndpointUrl()), null, headers, listener);
    }

    @CheckResult
    public AsyncTask vaultUnlockSignatureHeader(@NonNull PowerAuthConfiguration configuration, @NonNull PowerAuthClientConfiguration clientConfiguration, @NonNull Map<String, String> headers, @NonNull INetworkResponseListener<VaultUnlockResponse> listener) {
        return this.execute(configuration, clientConfiguration, new PA2VaultUnlockEndpoint(configuration.getBaseEndpointUrl()), null, headers, listener);
    }

    private class RestExecutor<TRequest, TResponse>
    extends AsyncTask<TRequest, Void, Void> {
        private static final String CONTENT_TYPE_JSON = "application/json";
        private PowerAuthClientConfiguration clientConfiguration;
        private IEndpointDefinition<TRequest> requestDefinition;
        private INetworkResponseListener<TResponse> responseListener;
        @Nullable
        private Map<String, String> headers;

        private RestExecutor(@Nullable PowerAuthClientConfiguration clientConfiguration, @NonNull Map<String, String> headers, @NonNull IEndpointDefinition<TRequest> requestDefinition, INetworkResponseListener<TResponse> responseListener) {
            this.clientConfiguration = clientConfiguration;
            this.headers = headers;
            this.requestDefinition = requestDefinition;
            this.responseListener = responseListener;
        }

        protected Void doInBackground(TRequest ... params) {
            URL url;
            try {
                url = new URL(this.requestDefinition.getEndpoint());
            }
            catch (MalformedURLException e) {
                PA2Client.this.callOnErrorUi(e, this.responseListener);
                return null;
            }
            try {
                PowerAuthApiRequest requestObject = new PowerAuthApiRequest(params[0]);
                String jsonRequestObject = PA2Client.this.mGson.toJson((Object)requestObject);
                byte[] postDataBytes = jsonRequestObject.getBytes("UTF-8");
                HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
                urlConnection.setRequestMethod("POST");
                urlConnection.setDoOutput(true);
                urlConnection.setUseCaches(false);
                urlConnection.setRequestProperty("Content-Type", CONTENT_TYPE_JSON);
                urlConnection.setRequestProperty("Accept", CONTENT_TYPE_JSON);
                if (this.headers != null) {
                    for (Map.Entry<String, String> header : this.headers.entrySet()) {
                        urlConnection.setRequestProperty(header.getKey(), header.getValue());
                    }
                }
                urlConnection.setConnectTimeout(this.clientConfiguration.getConnectionTimeout());
                urlConnection.setReadTimeout(this.clientConfiguration.getReadTimeout());
                PA2ClientValidationStrategy clientValidationStrategy = this.clientConfiguration.getClientValidationStrategy();
                if (clientValidationStrategy != null) {
                    HostnameVerifier hostnameVerifier;
                    SSLSocketFactory sslSocketFactory = clientValidationStrategy.getSSLSocketFactory();
                    if (sslSocketFactory != null) {
                        urlConnection.setSSLSocketFactory(sslSocketFactory);
                    }
                    if ((hostnameVerifier = clientValidationStrategy.getHostnameVerifier()) != null) {
                        urlConnection.setHostnameVerifier(hostnameVerifier);
                    }
                }
                urlConnection.getOutputStream().write(postDataBytes);
                urlConnection.connect();
                int responseCode = urlConnection.getResponseCode();
                switch (responseCode) {
                    case 200: 
                    case 400: 
                    case 401: {
                        InputStream inputStream = urlConnection.getInputStream();
                        JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(inputStream));
                        JsonObject jsonObject = new JsonParser().parse(jsonReader).getAsJsonObject();
                        String status = jsonObject.get("status").getAsString();
                        JsonElement responseObjectElement = jsonObject.get("responseObject");
                        if (status.equalsIgnoreCase("OK")) {
                            if (this.requestDefinition.getResponseType() != null) {
                                Object response = PA2Client.this.mGson.fromJson(responseObjectElement, this.requestDefinition.getResponseType().getType());
                                PA2Client.this.callOnResponseUi(response, this.responseListener);
                            } else {
                                PA2Client.this.callOnResponseUi(null, this.responseListener);
                            }
                        } else {
                            ErrorModel error = (ErrorModel)PA2Client.this.mGson.fromJson(responseObjectElement, TypeToken.get(ErrorModel.class).getType());
                            PA2Client.this.callOnErrorUi(new ErrorResponseApiException(error), this.responseListener);
                        }
                        jsonReader.close();
                        break;
                    }
                    default: {
                        PA2Client.this.callOnErrorUi(new FailedApiException(responseCode), this.responseListener);
                        break;
                    }
                }
            }
            catch (JsonParseException | IOException e) {
                PA2Client.this.callOnErrorUi(e, this.responseListener);
            }
            return null;
        }
    }
}

