/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.keychain;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;

public class PA2Keychain {
    private String identifier;

    public PA2Keychain(String identifier) {
        this.identifier = identifier;
    }

    public synchronized boolean containsDataForKey(@NonNull Context context, @NonNull String key) {
        String serializedStateString = context.getSharedPreferences(this.identifier, 0).getString(key, null);
        return serializedStateString != null;
    }

    public synchronized byte[] dataForKey(@NonNull Context context, @NonNull String key) {
        String serializedStateString = context.getSharedPreferences(this.identifier, 0).getString(key, null);
        if (serializedStateString == null) {
            return null;
        }
        return Base64.decode((String)serializedStateString, (int)0);
    }

    public synchronized void putDataForKey(@NonNull Context context, @Nullable byte[] data, @NonNull String key) {
        String serializedStateString = Base64.encodeToString((byte[])data, (int)0);
        context.getSharedPreferences(this.identifier, 0).edit().putString(key, serializedStateString).apply();
    }

    public synchronized boolean removeDataForKey(@NonNull Context context, @NonNull String key) {
        String serializedStateString = context.getSharedPreferences(this.identifier, 0).getString(key, null);
        if (serializedStateString == null) {
            return false;
        }
        context.getSharedPreferences(this.identifier, 0).edit().remove(key).apply();
        return true;
    }
}

