/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache;

import coursierapi.shaded.coursier.cache.ArchiveType;
import coursierapi.shaded.coursier.cache.ArchiveType$Gzip$;
import coursierapi.shaded.coursier.cache.ArchiveType$Tbz2$;
import coursierapi.shaded.coursier.cache.ArchiveType$Tgz$;
import coursierapi.shaded.coursier.cache.ArchiveType$Zip$;
import coursierapi.shaded.plexus.archiver.tar.TarBZip2UnArchiver;
import coursierapi.shaded.plexus.archiver.tar.TarGZipUnArchiver;
import coursierapi.shaded.plexus.archiver.zip.ZipUnArchiver;
import coursierapi.shaded.plexus.logging.AbstractLogger;
import coursierapi.shaded.plexus.logging.Logger;
import coursierapi.shaded.scala.Array$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.collection.StringOps$;
import coursierapi.shaded.scala.package$;
import coursierapi.shaded.scala.reflect.ClassTag$;
import coursierapi.shaded.scala.runtime.BoxedUnit;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Left;
import coursierapi.shaded.scala.util.Right;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.GZIPInputStream;

public interface UnArchiver {
    public void extract(ArchiveType var1, File var2, File var3, boolean var4);

    private static final class DefaultUnArchiver
    implements UnArchiver {
        private Logger nopLogger() {
            return new AbstractLogger(null){

                public void debug(String message, Throwable throwable) {
                }

                public void info(String message, Throwable throwable) {
                }

                public void warn(String message, Throwable throwable) {
                }
            };
        }

        @Override
        public void extract(ArchiveType archiveType, File archive, File destDir, boolean overwrite) {
            Either either;
            ArchiveType archiveType2 = archiveType;
            if (ArchiveType$Zip$.MODULE$.equals(archiveType2)) {
                ZipUnArchiver u = new ZipUnArchiver();
                u.enableLogging(this.nopLogger());
                either = package$.MODULE$.Right().apply(u);
            } else if (ArchiveType$Tgz$.MODULE$.equals(archiveType2)) {
                TarGZipUnArchiver u = new TarGZipUnArchiver();
                u.enableLogging(this.nopLogger());
                either = package$.MODULE$.Right().apply(u);
            } else if (ArchiveType$Tbz2$.MODULE$.equals(archiveType2)) {
                TarBZip2UnArchiver u = new TarBZip2UnArchiver();
                u.enableLogging(this.nopLogger());
                either = package$.MODULE$.Right().apply(u);
            } else if (ArchiveType$Gzip$.MODULE$.equals(archiveType2)) {
                either = package$.MODULE$.Left().apply(() -> {
                    File dest = new File(destDir, StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(archive.getName()), ".gz"));
                    FileInputStream fis = null;
                    FileOutputStream fos = null;
                    GZIPInputStream gzis = null;
                    try {
                        fis = new FileInputStream(archive);
                        gzis = new GZIPInputStream(fis);
                        fos = new FileOutputStream(dest);
                        byte[] buf = (byte[])Array$.MODULE$.ofDim(16384, ClassTag$.MODULE$.Byte());
                        int read = -1;
                        while ((read = gzis.read(buf)) >= 0) {
                            if (read <= 0) continue;
                            fos.write(buf, 0, read);
                        }
                        fos.flush();
                    }
                    finally {
                        if (gzis != null) {
                            gzis.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                });
            } else {
                throw new MatchError(archiveType2);
            }
            Right unArchiver = either;
            destDir.mkdirs();
            Right right = unArchiver;
            if (right instanceof Left) {
                Left left = (Left)((Object)right);
                Function0 f = (Function0)left.value();
                f.apply$mcV$sp();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (right instanceof Right) {
                Right right2 = right;
                coursierapi.shaded.plexus.archiver.UnArchiver u = right2.value();
                u.setOverwrite(false);
                u.setSourceFile(archive);
                u.setDestDirectory(destDir);
                u.extract();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(right);
            }
        }
    }
}

