/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.fitter;

import io.fair_acc.math.ArrayConversion;
import io.fair_acc.math.ArrayMath;
import io.fair_acc.math.Math;
import io.fair_acc.math.MathBase;
import io.fair_acc.math.fitter.NonLinearRegressionFitter;
import io.fair_acc.math.functions.Function;
import io.fair_acc.math.functions.Function1D;
import io.fair_acc.math.functions.FunctionND;
import io.fair_acc.math.matrix.MatrixD;
import io.fair_acc.math.storage.DoubleStorage1D;
import io.fair_acc.math.storage.VoxelArrayND;
import java.util.ArrayList;

@Deprecated
public class NonLinearRegressionFitter2 {
    protected static double histTol = 1.0001;
    protected int nData = 0;
    protected int nYarrays = 1;
    protected int nTerms = 0;
    protected int degreesOfFreedom = 0;
    protected VoxelArrayND xData = null;
    protected VoxelArrayND yData = null;
    protected VoxelArrayND yCalc = null;
    protected VoxelArrayND weight = null;
    protected VoxelArrayND residual = null;
    protected VoxelArrayND residualW = null;
    protected boolean weightOpt = false;
    protected int weightFlag = 0;
    protected double[] best = null;
    protected double[] bestSd = null;
    protected double[] pseudoSd = null;
    protected double[] tValues = null;
    protected double[] pValues = null;
    protected double chiSquare = Double.NaN;
    protected double reducedChiSquare = Double.NaN;
    protected double sumOfSquares = Double.NaN;
    protected double lastSSnoConstraint = 0.0;
    protected double[][] covar = null;
    protected double[][] corrCoeff = null;
    protected boolean linNonLin = true;
    protected boolean trueFreq = false;
    protected boolean nlrStatus = true;
    protected int scaleOpt = 0;
    protected double[] fscale = null;
    protected boolean zeroCheck = false;
    protected boolean penalty = false;
    protected boolean sumPenalty = false;
    protected int nConstraints = 0;
    protected int nSumConstraints = 0;
    protected int maxConstraintIndex = -1;
    protected double constraintTolerance = 1.0E-4;
    protected ArrayList<Object> penalties = new ArrayList();
    protected ArrayList<Object> sumPenalties = new ArrayList();
    protected int[] penaltyCheck = null;
    protected int[] sumPenaltyCheck = null;
    protected double penaltyWeight = 1.0E30;
    protected int[] penaltyParam = null;
    protected int[][] sumPenaltyParam = null;
    protected double[][] sumPlusOrMinus = null;
    protected int[] sumPenaltyNumber = null;
    protected double[] constraints = null;
    protected double[] sumConstraints = null;
    protected int constraintMethod = 0;
    protected int nMax = 3000;
    protected int nIter = 0;
    protected int konvge = 3;
    protected int kRestart = 0;
    protected double fMin = -1.0;
    protected double fTol = 1.0E-9;
    protected double rCoeff = 1.0;
    protected double eCoeff = 2.0;
    protected double cCoeff = 0.5;
    protected double[] startH = null;
    protected double[] step = null;
    protected double dStep = 0.5;
    protected double[][] grad = null;
    protected double delta = 1.0E-4;
    protected boolean invertFlag = true;
    protected boolean posVarFlag = true;
    protected int minTest = 0;
    protected double simplexSd = 0.0;
    protected boolean statFlag = true;
    protected boolean multipleY = false;
    protected double[] values = null;
    protected boolean[] fixed = null;
    protected boolean ignoreDofFcheck = false;
    protected boolean nFactorOption = false;

    public NonLinearRegressionFitter2(double[] xData, double[] yData, double[] weight) {
        this.setData(xData, yData, weight);
    }

    public NonLinearRegressionFitter2(VoxelArrayND xData, VoxelArrayND yData, VoxelArrayND weights) {
        this.setData(xData, yData, weights);
    }

    public void addConstraint(int paramIndex, int conDir, double constraint) {
        this.penalty = true;
        if (this.penalties.isEmpty()) {
            this.penalties.add(this.constraintMethod);
        }
        if (this.penalties.size() == 1) {
            this.penalties.add(1);
        } else {
            int nPC = (Integer)this.penalties.get(1);
            this.penalties.set(1, ++nPC);
        }
        this.penalties.add(paramIndex);
        this.penalties.add(conDir);
        this.penalties.add(constraint);
        if (paramIndex > this.maxConstraintIndex) {
            this.maxConstraintIndex = paramIndex;
        }
    }

    public void addConstraint(int[] paramIndices, double[] plusOrMinus, int conDir, double constraint) {
        int nCon = paramIndices.length;
        int nPorM = plusOrMinus.length;
        if (nCon != nPorM) {
            throw new IllegalArgumentException("num of parameters, " + nCon + ", does not equal number of parameter signs, " + nPorM);
        }
        this.sumPenalty = true;
        if (this.sumPenalties.isEmpty()) {
            this.sumPenalties.add(this.constraintMethod);
        }
        if (this.sumPenalties.size() == 1) {
            this.sumPenalties.add(1);
        } else {
            int nPC = (Integer)this.sumPenalties.get(1);
            this.sumPenalties.set(1, ++nPC);
        }
        this.sumPenalties.add(nCon);
        this.sumPenalties.add(paramIndices);
        this.sumPenalties.add(plusOrMinus);
        this.sumPenalties.add(conDir);
        this.sumPenalties.add(constraint);
        int maxI = Math.maximum(paramIndices);
        if (maxI > this.maxConstraintIndex) {
            this.maxConstraintIndex = maxI;
        }
    }

    public void addConstraint(int[] paramIndices, int[] plusOrMinus, int conDir, double constraint) {
        double[] dpom = ArrayConversion.getDoubleArray(plusOrMinus);
        this.addConstraint(paramIndices, dpom, conDir, constraint);
    }

    protected VoxelArrayND checkForZeroWeights(VoxelArrayND weights) {
        this.weightOpt = true;
        int nZeros = 0;
        if (weights == null) {
            throw new IllegalArgumentException("weights are null");
        }
        for (int i = 0; i < weights.getLocalStorageDim(); ++i) {
            double[] val = weights.getLocal(i);
            for (int j = 0; j < val.length; ++j) {
                if (!(val[j] <= 0.0)) continue;
                ++nZeros;
            }
        }
        double perCentZeros = 100.0 * (double)nZeros / (double)weights.getLocalStorageDim();
        if (perCentZeros > 40.0) {
            System.out.println(perCentZeros + "% of the weights are zero or less; all weights set to 1.0");
            this.weight.initialiseWithValue(1.0);
            this.weightOpt = false;
        } else if (perCentZeros > 0.0) {
            this.weight.initialiseWithValue(1.0);
        }
        return this.weight;
    }

    public void checkZeroNeg(double[] xx, double[] yy, double[] ww) {
        int jj = 0;
        boolean test = true;
        for (int i = 0; i < this.nData; ++i) {
            if (!(yy[i] <= 0.0)) continue;
            if (i <= jj) {
                test = true;
                jj = i;
                while (test) {
                    if (++jj >= this.nData) {
                        throw new ArithmeticException("all zero cumulative data!!");
                    }
                    if (!(yy[jj] > 0.0)) continue;
                    yy[i] = yy[jj];
                    xx[i] = xx[jj];
                    ww[i] = ww[jj];
                    test = false;
                }
                continue;
            }
            if (i == this.nData - 1) {
                yy[i] = yy[i - 1];
                xx[i] = xx[i - 1];
                ww[i] = ww[i - 1];
                continue;
            }
            yy[i] = (yy[i - 1] + yy[i + 1]) / 2.0;
            xx[i] = (xx[i - 1] + xx[i + 1]) / 2.0;
            ww[i] = (ww[i - 1] + ww[i + 1]) / 2.0;
        }
    }

    public double[] getBestEstimates() {
        return (double[])this.best.clone();
    }

    public double[] getBestEstimatesErrors() {
        return (double[])this.bestSd.clone();
    }

    public double[] getbestestimatesStandardDeviations() {
        return (double[])this.bestSd.clone();
    }

    public double[] getBestEstimatesStandardDeviations() {
        return (double[])this.bestSd.clone();
    }

    public double getChiSquare() {
        double ret = 0.0;
        if (this.weightOpt) {
            ret = this.chiSquare;
        } else {
            System.out.println("Chi Square cannot be calculated as data are neither true frequencies nor weighted");
            System.out.println("A value of -1 is returned as Chi Square");
            ret = -1.0;
        }
        return ret;
    }

    public double getchiSquareProb() {
        double ret = 0.0;
        if (this.weightOpt) {
            ret = 1.0 - Math.chisquareQuantile(this.chiSquare, this.nData - 1);
        } else {
            System.out.println("A Chi Square probablity cannot be calculated as data are neither true frequencies nor weighted");
            System.out.println("A value of -1 is returned as Reduced Chi Square");
            ret = -1.0;
        }
        return ret;
    }

    public double[] getCoeff() {
        return (double[])this.best.clone();
    }

    public double[] getCoeffSd() {
        return (double[])this.bestSd.clone();
    }

    public double[] getCoeffVar() {
        double[] coeffVar = new double[this.nTerms];
        for (int i = 0; i < this.nTerms; ++i) {
            coeffVar[i] = this.bestSd[i] * 100.0 / this.best[i];
        }
        return coeffVar;
    }

    public double[][] getCorrCoeffMatrix() {
        return this.corrCoeff;
    }

    public double[][] getCovMatrix() {
        return this.covar;
    }

    public double getDegFree() {
        return this.degreesOfFreedom;
    }

    public double getDelta() {
        return this.delta;
    }

    public double[][] getGrad() {
        return this.grad;
    }

    public boolean getInversionCheck() {
        return this.invertFlag;
    }

    public int getMinTest() {
        return this.minTest;
    }

    public int getNiter() {
        return this.nIter;
    }

    public boolean getNlrStatus() {
        return this.nlrStatus;
    }

    public int getNmax() {
        return this.nMax;
    }

    public double getNMcontract() {
        return this.cCoeff;
    }

    public double getNMextend() {
        return this.eCoeff;
    }

    public double getNMreflect() {
        return this.rCoeff;
    }

    public int getNrestarts() {
        return this.kRestart;
    }

    public int getNrestartsMax() {
        return this.konvge;
    }

    public boolean getPosVarCheck() {
        return this.posVarFlag;
    }

    public double[] getPseudoErrors() {
        return (double[])this.pseudoSd.clone();
    }

    public double[] getPseudoSd() {
        return (double[])this.pseudoSd.clone();
    }

    public double[] getPvalues() {
        return (double[])this.pValues.clone();
    }

    public double getReducedChiSquare() {
        double ret = 0.0;
        if (this.weightOpt) {
            ret = this.reducedChiSquare;
        } else {
            System.out.println("A Reduced Chi Square cannot be calculated as data are neither true frequencies nor weighted");
            System.out.println("A value of -1 is returned as Reduced Chi Square");
            ret = -1.0;
        }
        return ret;
    }

    public double[] getResiduals() {
        double[] temp = new double[this.nData];
        for (int i = 0; i < this.nData; ++i) {
        }
        return temp;
    }

    public double[] getScale() {
        return this.fscale;
    }

    public double getSimplexSd() {
        return this.simplexSd;
    }

    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    public double getTolerance() {
        return this.fTol;
    }

    public boolean getTrueFreq() {
        return this.trueFreq;
    }

    public double[] getTvalues() {
        return (double[])this.tValues.clone();
    }

    public double[] getWeightedResiduals() {
        double[] temp = new double[this.nData];
        for (int i = 0; i < this.nData; ++i) {
        }
        return temp;
    }

    public double[] getXdata() {
        if (this.xData instanceof DoubleStorage1D) {
            return (double[])((DoubleStorage1D)this.xData).getArray().clone();
        }
        return null;
    }

    public double[] getYcalc() {
        if (this.yCalc instanceof DoubleStorage1D) {
            return (double[])((DoubleStorage1D)this.yCalc).getArray().clone();
        }
        return null;
    }

    public double[] getYdata() {
        if (this.yData instanceof DoubleStorage1D) {
            return (double[])((DoubleStorage1D)this.yData).getArray().clone();
        }
        return null;
    }

    public void ignoreDofFcheck() {
        this.ignoreDofFcheck = true;
    }

    protected void nelderMead(Object regFun, double[] start, double[] step, double fTol, int nMax) {
        int i;
        int i2;
        int j;
        int i3;
        int i4;
        int np = start.length;
        if (this.maxConstraintIndex >= np) {
            throw new IllegalArgumentException("You have entered more constrained parameters (" + this.maxConstraintIndex + ") than minimisation parameters (" + np + ")");
        }
        this.nlrStatus = true;
        this.nTerms = np;
        int nnp = np + 1;
        this.lastSSnoConstraint = 0.0;
        if (this.scaleOpt < 2) {
            this.fscale = new double[np];
        }
        if (this.scaleOpt == 2 && this.fscale.length != start.length) {
            throw new IllegalArgumentException("scale array and initial estimate array are of different lengths");
        }
        if (step.length != start.length) {
            throw new IllegalArgumentException("step array length " + step.length + " and initial estimate array length " + start.length + " are of different");
        }
        for (i4 = 0; i4 < np; ++i4) {
            if (step[i4] != 0.0) continue;
            throw new IllegalArgumentException("step " + i4 + " size is zero");
        }
        if (this.ignoreDofFcheck) {
            this.bestSd = new double[this.nTerms];
            this.pseudoSd = new double[this.nTerms];
            this.tValues = new double[this.nTerms];
            this.pValues = new double[this.nTerms];
            this.covar = new double[this.nTerms][this.nTerms];
            this.corrCoeff = new double[this.nTerms][this.nTerms];
            for (i4 = 0; i4 < this.nTerms; ++i4) {
                this.bestSd[i4] = Double.NaN;
                this.pseudoSd[i4] = Double.NaN;
                for (int j2 = 0; j2 < this.nTerms; ++j2) {
                    this.covar[i4][j2] = Double.NaN;
                    this.corrCoeff[i4][j2] = Double.NaN;
                }
            }
        }
        this.startH = new double[np];
        this.step = new double[np];
        double[] pmin = new double[np];
        this.best = new double[np];
        this.bestSd = new double[np];
        this.tValues = new double[np];
        this.pValues = new double[np];
        double[][] pp = new double[nnp][nnp];
        double[] yy = new double[nnp];
        double[] pbar = new double[nnp];
        double[] pstar = new double[nnp];
        double[] p2star = new double[nnp];
        double yabsmean = 0.0;
        int yabscount = 0;
        for (i3 = 0; i3 < this.yData.getLocalStorageDim(); ++i3) {
            double[] val = this.yData.getLocal(i3);
            for (j = 0; j < val.length; ++j) {
                yabsmean += Math.abs(val[j]);
                ++yabscount;
            }
        }
        double d = yabsmean = yabscount == 0 ? 0.0 : yabsmean / (double)yabscount;
        if (this.penalty) {
            Integer itemp = (Integer)this.penalties.get(1);
            this.nConstraints = itemp;
            this.penaltyParam = new int[this.nConstraints];
            this.penaltyCheck = new int[this.nConstraints];
            this.constraints = new double[this.nConstraints];
            Double dtemp = null;
            j = 2;
            for (i2 = 0; i2 < this.nConstraints; ++i2) {
                itemp = (Integer)this.penalties.get(j);
                this.penaltyParam[i2] = itemp;
                itemp = (Integer)this.penalties.get(++j);
                this.penaltyCheck[i2] = itemp;
                dtemp = (Double)this.penalties.get(++j);
                this.constraints[i2] = dtemp;
                ++j;
            }
        }
        if (this.sumPenalty) {
            Integer itemp = (Integer)this.sumPenalties.get(1);
            this.nSumConstraints = itemp;
            this.sumPenaltyParam = new int[this.nSumConstraints][];
            this.sumPlusOrMinus = new double[this.nSumConstraints][];
            this.sumPenaltyCheck = new int[this.nSumConstraints];
            this.sumPenaltyNumber = new int[this.nSumConstraints];
            this.sumConstraints = new double[this.nSumConstraints];
            int[] itempArray = null;
            double[] dtempArray = null;
            Double dtemp = null;
            int j3 = 2;
            for (int i5 = 0; i5 < this.nSumConstraints; ++i5) {
                itemp = (Integer)this.sumPenalties.get(j3);
                this.sumPenaltyNumber[i5] = itemp;
                itempArray = (int[])this.sumPenalties.get(++j3);
                this.sumPenaltyParam[i5] = itempArray;
                dtempArray = (double[])this.sumPenalties.get(++j3);
                this.sumPlusOrMinus[i5] = dtempArray;
                itemp = (Integer)this.sumPenalties.get(++j3);
                this.sumPenaltyCheck[i5] = itemp;
                dtemp = (Double)this.sumPenalties.get(++j3);
                this.sumConstraints[i5] = dtemp;
                ++j3;
            }
        }
        System.arraycopy(start, 0, this.startH, 0, np);
        if (this.scaleOpt > 0) {
            boolean testzero = false;
            for (int i6 = 0; i6 < np; ++i6) {
                if (start[i6] != 0.0) continue;
                testzero = true;
                break;
            }
            if (testzero) {
                System.out.println("Neler and Mead Simplex: a start value of zero precludes scaling");
                System.out.println("Regression performed without scaling");
                this.scaleOpt = 0;
            }
        }
        switch (this.scaleOpt) {
            case 0: {
                for (i3 = 0; i3 < np; ++i3) {
                    this.fscale[i3] = 1.0;
                }
                break;
            }
            case 1: {
                for (i3 = 0; i3 < np; ++i3) {
                    this.fscale[i3] = 1.0 / start[i3];
                    step[i3] = step[i3] / start[i3];
                    start[i3] = 1.0;
                }
                break;
            }
            case 2: {
                for (i3 = 0; i3 < np; ++i3) {
                    int n = i3;
                    step[n] = step[n] * this.fscale[i3];
                    int n2 = i3;
                    start[n2] = start[n2] * this.fscale[i3];
                }
                break;
            }
        }
        this.fTol = fTol;
        this.nMax = nMax;
        this.nIter = 0;
        for (i3 = 0; i3 < np; ++i3) {
            this.step[i3] = step[i3];
            this.fscale[i3] = this.fscale[i3];
        }
        double sho = 0.0;
        for (int i7 = 0; i7 < np; ++i7) {
            pstar[i7] = sho = start[i7];
            p2star[i7] = sho;
            pmin[i7] = sho;
        }
        int jcount = this.konvge;
        for (i2 = 0; i2 < np; ++i2) {
            pp[i2][nnp - 1] = start[i2];
        }
        yy[nnp - 1] = this.sumSquares(regFun, start);
        for (int j4 = 0; j4 < np; ++j4) {
            int n = j4;
            start[n] = start[n] + step[j4];
            for (int i8 = 0; i8 < np; ++i8) {
                pp[i8][j4] = start[i8];
            }
            yy[j4] = this.sumSquares(regFun, start);
            int n3 = j4;
            start[n3] = start[n3] - step[j4];
        }
        double ynewlo = 0.0;
        double ystar = 0.0;
        double y2star = 0.0;
        double ylo = 0.0;
        double curMin = 0.0;
        double sumnm = 0.0;
        double summnm = 0.0;
        double zn = 0.0;
        int ilo = 0;
        int ihi = 0;
        int ln = 0;
        boolean test = true;
        while (test) {
            int i9;
            int j5;
            ynewlo = ylo = yy[0];
            ilo = 0;
            ihi = 0;
            for (i = 1; i < nnp; ++i) {
                if (yy[i] < ylo) {
                    ylo = yy[i];
                    ilo = i;
                }
                if (!(yy[i] > ynewlo)) continue;
                ynewlo = yy[i];
                ihi = i;
            }
            for (i = 0; i < np; ++i) {
                zn = 0.0;
                for (int j6 = 0; j6 < nnp; ++j6) {
                    zn += pp[i][j6];
                }
                pbar[i] = (zn -= pp[i][ihi]) / (double)np;
            }
            for (i = 0; i < np; ++i) {
                pstar[i] = (1.0 + this.rCoeff) * pbar[i] - this.rCoeff * pp[i][ihi];
            }
            ystar = this.sumSquares(regFun, pstar);
            ++this.nIter;
            if (ystar < ylo) {
                for (i = 0; i < np; ++i) {
                    p2star[i] = pstar[i] * (1.0 + this.eCoeff) - this.eCoeff * pbar[i];
                }
                y2star = this.sumSquares(regFun, p2star);
                ++this.nIter;
                if (y2star < ylo) {
                    for (i = 0; i < np; ++i) {
                        pp[i][ihi] = p2star[i];
                    }
                    yy[ihi] = y2star;
                } else {
                    for (i = 0; i < np; ++i) {
                        pp[i][ihi] = pstar[i];
                    }
                    yy[ihi] = ystar;
                }
            } else {
                ln = 0;
                for (i = 0; i < nnp; ++i) {
                    if (i == ihi || !(ystar > yy[i])) continue;
                    ++ln;
                }
                if (ln == np) {
                    if (ystar <= yy[ihi]) {
                        for (i = 0; i < np; ++i) {
                            pp[i][ihi] = pstar[i];
                        }
                        yy[ihi] = ystar;
                    }
                    for (i = 0; i < np; ++i) {
                        p2star[i] = this.cCoeff * pp[i][ihi] + (1.0 - this.cCoeff) * pbar[i];
                    }
                    y2star = this.sumSquares(regFun, p2star);
                    ++this.nIter;
                    if (y2star > yy[ihi]) {
                        for (j5 = 0; j5 < nnp; ++j5) {
                            for (i9 = 0; i9 < np; ++i9) {
                                pp[i9][j5] = 0.5 * (pp[i9][j5] + pp[i9][ilo]);
                                pmin[i9] = pp[i9][j5];
                            }
                            yy[j5] = this.sumSquares(regFun, pmin);
                        }
                        this.nIter += nnp;
                    } else {
                        for (i = 0; i < np; ++i) {
                            pp[i][ihi] = p2star[i];
                        }
                        yy[ihi] = y2star;
                    }
                } else {
                    for (i = 0; i < np; ++i) {
                        pp[i][ihi] = pstar[i];
                    }
                    yy[ihi] = ystar;
                }
            }
            sumnm = 0.0;
            ynewlo = yy[0];
            ilo = 0;
            for (i = 0; i < nnp; ++i) {
                sumnm += yy[i];
                if (!(ynewlo > yy[i])) continue;
                ynewlo = yy[i];
                ilo = i;
            }
            sumnm /= (double)nnp;
            summnm = 0.0;
            for (i = 0; i < nnp; ++i) {
                zn = yy[i] - sumnm;
                summnm += zn * zn;
            }
            curMin = Math.sqrt(summnm / (double)np);
            switch (this.minTest) {
                case 0: {
                    if (!(curMin < fTol)) break;
                    test = false;
                    break;
                }
                case 1: {
                    if (!(Math.sqrt(ynewlo / (double)this.degreesOfFreedom) < yabsmean * fTol)) break;
                    test = false;
                }
            }
            this.sumOfSquares = ynewlo;
            if (!test) {
                for (i = 0; i < np; ++i) {
                    pmin[i] = pp[i][ilo];
                }
                yy[nnp - 1] = ynewlo;
                this.simplexSd = curMin;
                if (--jcount > 0) {
                    test = true;
                    for (j5 = 0; j5 < np; ++j5) {
                        pmin[j5] = pmin[j5] + step[j5];
                        for (i9 = 0; i9 < np; ++i9) {
                            pp[i9][j5] = pmin[i9];
                        }
                        yy[j5] = this.sumSquares(regFun, pmin);
                        pmin[j5] = pmin[j5] - step[j5];
                    }
                }
            }
            if (!test || this.nIter <= this.nMax) continue;
            System.out.println("Maximum iteration number reached, in Regression.simplex(...)");
            System.out.println("without the convergence criterion being satisfied");
            System.out.println("Current parameter estimates and sum of squares values returned");
            this.nlrStatus = false;
            for (i = 0; i < np; ++i) {
                pmin[i] = pp[i][ilo];
            }
            yy[nnp - 1] = ynewlo;
            test = false;
        }
        for (i = 0; i < np; ++i) {
            pmin[i] = pp[i][ilo];
            this.best[i] = pmin[i] / this.fscale[i];
            this.fscale[i] = 1.0;
        }
        this.fMin = ynewlo;
        this.kRestart = this.konvge - jcount;
        if (this.statFlag) {
            if (!this.ignoreDofFcheck) {
                this.pseudoLinearStats(regFun);
            }
        } else {
            for (i = 0; i < np; ++i) {
                this.bestSd[i] = Double.NaN;
            }
        }
    }

    protected int pseudoLinearStats(Object regFun) {
        int j;
        int i;
        int i2;
        double f1 = 0.0;
        double f2 = 0.0;
        double f3 = 0.0;
        double f4 = 0.0;
        int flag = 0;
        int np = this.nTerms;
        double[] f = new double[np];
        double[] pmin = new double[np];
        double[] coeffSd = new double[np];
        double[][] stat = new double[np][np];
        this.pseudoSd = new double[np];
        this.grad = new double[np][2];
        this.covar = new double[np][np];
        this.corrCoeff = new double[np][np];
        pmin = (double[])this.best.clone();
        double hold0 = 1.0;
        double hold1 = 1.0;
        for (i2 = 0; i2 < np; ++i2) {
            System.arraycopy(pmin, 0, f, 0, np);
            hold0 = pmin[i2];
            if (hold0 == 0.0) {
                hold0 = this.step[i2];
                this.zeroCheck = true;
            }
            f[i2] = hold0 * (1.0 - this.delta);
            this.lastSSnoConstraint = this.sumOfSquares;
            f1 = this.sumSquares(regFun, f);
            f[i2] = hold0 * (1.0 + this.delta);
            this.lastSSnoConstraint = this.sumOfSquares;
            f2 = this.sumSquares(regFun, f);
            this.grad[i2][0] = (this.fMin - f1) / Math.abs(this.delta * hold0);
            this.grad[i2][1] = (f2 - this.fMin) / Math.abs(this.delta * hold0);
        }
        this.lastSSnoConstraint = this.sumOfSquares;
        for (i2 = 0; i2 < np; ++i2) {
            for (int j2 = 0; j2 < np; ++j2) {
                System.arraycopy(pmin, 0, f, 0, np);
                hold0 = f[i2];
                if (hold0 == 0.0) {
                    hold0 = this.step[i2];
                    this.zeroCheck = true;
                }
                f[i2] = hold0 * (1.0 + this.delta / 2.0);
                hold0 = f[j2];
                if (hold0 == 0.0) {
                    hold0 = this.step[j2];
                    this.zeroCheck = true;
                }
                f[j2] = hold0 * (1.0 + this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                f1 = this.sumSquares(regFun, f);
                f[i2] = pmin[i2];
                f[j2] = pmin[j2];
                hold0 = f[i2];
                if (hold0 == 0.0) {
                    hold0 = this.step[i2];
                    this.zeroCheck = true;
                }
                f[i2] = hold0 * (1.0 - this.delta / 2.0);
                hold0 = f[j2];
                if (hold0 == 0.0) {
                    hold0 = this.step[j2];
                    this.zeroCheck = true;
                }
                f[j2] = hold0 * (1.0 + this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                f2 = this.sumSquares(regFun, f);
                f[i2] = pmin[i2];
                f[j2] = pmin[j2];
                hold0 = f[i2];
                if (hold0 == 0.0) {
                    hold0 = this.step[i2];
                    this.zeroCheck = true;
                }
                f[i2] = hold0 * (1.0 + this.delta / 2.0);
                hold0 = f[j2];
                if (hold0 == 0.0) {
                    hold0 = this.step[j2];
                    this.zeroCheck = true;
                }
                f[j2] = hold0 * (1.0 - this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                f3 = this.sumSquares(regFun, f);
                f[i2] = pmin[i2];
                f[j2] = pmin[j2];
                hold0 = f[i2];
                if (hold0 == 0.0) {
                    hold0 = this.step[i2];
                    this.zeroCheck = true;
                }
                f[i2] = hold0 * (1.0 - this.delta / 2.0);
                hold0 = f[j2];
                if (hold0 == 0.0) {
                    hold0 = this.step[j2];
                    this.zeroCheck = true;
                }
                f[j2] = hold0 * (1.0 - this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                f4 = this.sumSquares(regFun, f);
                stat[i2][j2] = (f1 - f2 - f3 + f4) / (this.delta * this.delta);
            }
        }
        if (regFun instanceof Function) {
            ((Function)regFun).setFitterMode(true);
            Function func = (Function)regFun;
            for (int i3 = 0; i3 < func.getParameterCount(); ++i3) {
                if (func.isParameterFixed(i3)) continue;
                func.setParameterValue(i3, pmin[i3]);
            }
        }
        double ss = 0.0;
        double sc = 0.0;
        for (i = 0; i < this.yCalc.getLocalStorageDim(); ++i) {
            double[] xd;
            if (regFun instanceof FunctionND) {
                xd = this.xData.getLocal(i);
                double[] val = ((FunctionND)regFun).getValue(xd);
                this.yCalc.setLocal(i, val);
                continue;
            }
            if (!(regFun instanceof Function1D)) continue;
            xd = ((DoubleStorage1D)this.xData).getArray();
            double[] yCalcLocal = ((DoubleStorage1D)this.yCalc).getArray();
            for (int j3 = 0; j3 < xd.length; ++j3) {
                yCalcLocal[j3] = ((Function1D)regFun).getValue(xd[j3]);
            }
        }
        for (i = 0; i < this.yCalc.getLocalStorageDim(); ++i) {
            double[] val = ArrayMath.subtract(this.yCalc.getLocal(i), this.yData.getLocal(i));
            double[] val2 = this.residualW.getLocal(i);
            double[] weightLocal = this.weight.getLocal(i);
            this.residual.setLocal(i, val);
            for (j = 0; j < val.length; ++j) {
                ss += MathBase.sqr(val[j]);
                val2[j] = val[j] / weightLocal[j];
                sc += MathBase.sqr(val2[j]);
            }
        }
        if (regFun instanceof Function) {
            ((Function)regFun).setFitterMode(false);
        }
        this.sumOfSquares = ss;
        if (this.weightOpt || this.trueFreq) {
            this.chiSquare = sc;
            this.reducedChiSquare = sc / (double)(this.nData - np);
        }
        double red = 1.0;
        if (!this.weightOpt && !this.trueFreq) {
            red = this.sumOfSquares / (double)(this.nData - np);
        }
        for (int i4 = 0; i4 < np; ++i4) {
            this.pseudoSd[i4] = 2.0 * this.delta * red * Math.abs(pmin[i4]) / (this.grad[i4][1] - this.grad[i4][0]);
            this.pseudoSd[i4] = this.pseudoSd[i4] >= 0.0 ? Math.sqrt(this.pseudoSd[i4]) : Double.NaN;
        }
        if (np == 1) {
            hold0 = pmin[0];
            if (hold0 == 0.0) {
                hold0 = this.step[0];
            }
            stat[0][0] = 1.0 / stat[0][0];
            this.covar[0][0] = stat[0][0] * red * hold0 * hold0;
            if (this.covar[0][0] >= 0.0) {
                coeffSd[0] = Math.sqrt(this.covar[0][0]);
                this.corrCoeff[0][0] = 1.0;
            } else {
                coeffSd[0] = Double.NaN;
                this.corrCoeff[0][0] = Double.NaN;
                this.posVarFlag = false;
            }
        } else {
            MatrixD cov = new MatrixD(stat);
            this.invertFlag = true;
            cov.print(5, 5);
            cov = cov.pseudoInverse(1.0E12);
            cov.print(5, 5);
            if (!this.invertFlag) {
                --flag;
            }
            stat = cov.getArrayCopy();
            this.posVarFlag = true;
            if (this.invertFlag) {
                int i5;
                for (i5 = 0; i5 < np; ++i5) {
                    hold0 = pmin[i5];
                    if (hold0 == 0.0) {
                        hold0 = this.step[i5];
                    }
                    for (j = i5; j < np; ++j) {
                        hold1 = pmin[j];
                        if (hold1 == 0.0) {
                            hold1 = this.step[j];
                        }
                        this.covar[i5][j] = 2.0 * stat[i5][j] * red * hold0 * hold1;
                        this.covar[j][i5] = this.covar[i5][j];
                    }
                    if (this.covar[i5][i5] >= 0.0) {
                        coeffSd[i5] = Math.sqrt(this.covar[i5][i5]);
                        continue;
                    }
                    coeffSd[i5] = Double.NaN;
                    this.posVarFlag = false;
                }
                for (i5 = 0; i5 < np; ++i5) {
                    for (j = 0; j < np; ++j) {
                        this.corrCoeff[i5][j] = Double.isFinite(coeffSd[i5]) && Double.isFinite(coeffSd[j]) ? this.covar[i5][j] / (coeffSd[i5] * coeffSd[j]) : Double.NaN;
                    }
                }
            } else {
                for (int i6 = 0; i6 < np; ++i6) {
                    for (j = 0; j < np; ++j) {
                        this.covar[i6][j] = Double.NaN;
                        this.corrCoeff[i6][j] = Double.NaN;
                    }
                    coeffSd[i6] = Double.NaN;
                    this.posVarFlag = false;
                }
            }
        }
        if (!this.posVarFlag) {
            --flag;
        }
        for (int i7 = 0; i7 < this.nTerms; ++i7) {
            this.bestSd[i7] = coeffSd[i7];
            this.tValues[i7] = this.best[i7] / this.bestSd[i7];
            double atv = Math.abs(this.tValues[i7]);
            this.pValues[i7] = 1.0 - Math.student(atv, this.degreesOfFreedom);
        }
        return flag;
    }

    public void removeConstraints() {
        int m;
        if (!this.penalties.isEmpty()) {
            m = this.penalties.size();
            this.penalties.subList(0, m).clear();
        }
        this.penalty = false;
        this.nConstraints = 0;
        if (!this.sumPenalties.isEmpty()) {
            m = this.sumPenalties.size();
            this.sumPenalties.subList(0, m).clear();
        }
        this.sumPenalty = false;
        this.nSumConstraints = 0;
        this.maxConstraintIndex = -1;
    }

    public void setConstraintTolerance(double tolerance) {
        this.constraintTolerance = tolerance;
    }

    public void setData(double[] xData, double[] yData, double[] weights) {
        DoubleStorage1D xDataLocal = new DoubleStorage1D(xData);
        DoubleStorage1D yDataLocal = new DoubleStorage1D(xData);
        DoubleStorage1D weightLocal = new DoubleStorage1D(weights);
        this.setData(xDataLocal, yDataLocal, weightLocal);
    }

    public void setData(VoxelArrayND xData, VoxelArrayND yData, VoxelArrayND weights) {
        this.weight = this.checkForZeroWeights(weights);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.xData = xData;
        this.yData = yData;
        this.weight = weights;
        this.yCalc = yData.copy();
        this.residual = yData.copy();
        this.residualW = yData.copy();
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public void setMinTest(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("minTest must be 0 or 1");
        }
        this.minTest = n;
    }

    public void setNmax(int nmax) {
        this.nMax = nmax;
    }

    public void setNMcontract(double con) {
        this.cCoeff = con;
    }

    public void setNMextend(double ext) {
        this.eCoeff = ext;
    }

    public void setNMreflect(double refl) {
        this.rCoeff = refl;
    }

    public void setNrestartsMax(int nrs) {
        this.konvge = nrs;
    }

    public void setScale(double[] sc) {
        this.fscale = sc;
        this.scaleOpt = 2;
    }

    public void setScale(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("The argument must be 0 (no scaling) 1(initial estimates all scaled to unity) or the array of scaling factors");
        }
        this.scaleOpt = n;
    }

    public void setTolerance(double tol) {
        this.fTol = tol;
    }

    public void setTrueFreq(boolean trFr) {
        boolean trFrOld = this.trueFreq;
        this.trueFreq = trFr;
        if (trFr) {
            boolean flag = NonLinearRegressionFitter2.setTrueFreqWeights(this.yData, this.weight);
            if (flag) {
                this.trueFreq = true;
                this.weightOpt = true;
            } else {
                this.trueFreq = false;
                this.weightOpt = false;
            }
        } else if (trFrOld) {
            this.weight.initialiseWithValue(1.0);
            this.weightOpt = false;
        }
    }

    public void simplex(Function1D g, double[] start) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        int n = start.length;
        int nMaxx = this.nMax;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fToll, nMaxx);
    }

    public void simplex(Function1D g, double[] start, double fTol) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        int n = start.length;
        int nMaxx = this.nMax;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fTol, nMaxx);
    }

    public void simplex(Function1D g, double[] start, double fTol, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        int n = start.length;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fTol, nMax);
    }

    public void simplex(Function1D g, double[] start, double[] step) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        double fToll = this.fTol;
        int nMaxx = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fToll, nMaxx);
    }

    public void simplex(Function1D g, double[] start, double[] step, double fTol) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        int nMaxx = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fTol, nMaxx);
    }

    public void simplex(Function1D g, double[] start, double[] step, double fTol, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fTol, nMax);
    }

    public void simplex(Function1D g, double[] start, double[] step, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        double fToll = this.fTol;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fToll, nMax);
    }

    public void simplex(Function1D g, double[] start, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        int n = start.length;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fToll, nMax);
    }

    public void simplex2(FunctionND g, double[] start) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        int n = start.length;
        int nMaxx = this.nMax;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fToll, nMaxx);
    }

    public void simplex2(FunctionND g, double[] start, double fTol) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        int n = start.length;
        int nMaxx = this.nMax;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fTol, nMaxx);
    }

    public void simplex2(FunctionND g, double[] start, double fTol, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        int n = start.length;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fTol, nMax);
    }

    public void simplex2(FunctionND g, double[] start, double[] step) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        double fToll = this.fTol;
        int nMaxx = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fToll, nMaxx);
    }

    public void simplex2(FunctionND g, double[] start, double[] step, double fTol) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        int nMaxx = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fTol, nMaxx);
    }

    public void simplex2(FunctionND g, double[] start, double[] step, double fTol, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fTol, nMax);
    }

    public void simplex2(FunctionND g, double[] start, double[] step, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        double fToll = this.fTol;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fToll, nMax);
    }

    public void simplex2(FunctionND g, double[] start, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        int n = start.length;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fToll, nMax);
    }

    protected double sumSquares(Object regFun, double[] testParameter) {
        int i;
        double ss = -3.0;
        double[] param = new double[this.nTerms];
        for (int i2 = 0; i2 < this.nTerms; ++i2) {
            param[i2] = testParameter[i2] / this.fscale[i2];
        }
        double tempFunctVal = this.lastSSnoConstraint;
        boolean test = true;
        if (this.penalty) {
            int k = 0;
            block11: for (i = 0; i < this.nConstraints; ++i) {
                k = this.penaltyParam[i];
                switch (this.penaltyCheck[i]) {
                    case -1: {
                        if (!(param[k] < this.constraints[i])) continue block11;
                        ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(this.constraints[i] - param[k]);
                        test = false;
                        continue block11;
                    }
                    case 0: {
                        if (param[k] < this.constraints[i] * (1.0 - this.constraintTolerance)) {
                            ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(this.constraints[i] * (1.0 - this.constraintTolerance) - param[k]);
                            test = false;
                        }
                        if (!(param[k] > this.constraints[i] * (1.0 + this.constraintTolerance))) continue block11;
                        ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(param[k] - this.constraints[i] * (1.0 + this.constraintTolerance));
                        test = false;
                        continue block11;
                    }
                    case 1: {
                        if (!(param[k] > this.constraints[i])) continue block11;
                        ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(param[k] - this.constraints[i]);
                        test = false;
                    }
                }
            }
        }
        if (this.sumPenalty) {
            int kk = 0;
            double pSign = 0.0;
            double sumPenaltySum = 0.0;
            block12: for (int i3 = 0; i3 < this.nSumConstraints; ++i3) {
                for (int j = 0; j < this.sumPenaltyNumber[i3]; ++j) {
                    kk = this.sumPenaltyParam[i3][j];
                    pSign = this.sumPlusOrMinus[i3][j];
                    sumPenaltySum += param[kk] * pSign;
                }
                switch (this.sumPenaltyCheck[i3]) {
                    case -1: {
                        if (!(sumPenaltySum < this.sumConstraints[i3])) continue block12;
                        ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(this.sumConstraints[i3] - sumPenaltySum);
                        test = false;
                        continue block12;
                    }
                    case 0: {
                        if (sumPenaltySum < this.sumConstraints[i3] * (1.0 - this.constraintTolerance)) {
                            ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(this.sumConstraints[i3] * (1.0 - this.constraintTolerance) - sumPenaltySum);
                            test = false;
                        }
                        if (!(sumPenaltySum > this.sumConstraints[i3] * (1.0 + this.constraintTolerance))) continue block12;
                        ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(sumPenaltySum - this.sumConstraints[i3] * (1.0 + this.constraintTolerance));
                        test = false;
                        continue block12;
                    }
                    case 1: {
                        if (!(sumPenaltySum > this.sumConstraints[i3])) continue block12;
                        ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(sumPenaltySum - this.sumConstraints[i3]);
                        test = false;
                    }
                }
            }
        }
        if (test) {
            if (regFun instanceof Function) {
                ((Function)regFun).setFitterMode(true);
                Function func = (Function)regFun;
                for (i = 0; i < func.getParameterCount(); ++i) {
                    if (func.isParameterFixed(i)) continue;
                    func.setParameterValue(i, param[i]);
                }
            }
            ss = 0.0;
            if (regFun instanceof Function1D) {
                Function1D g1 = (Function1D)regFun;
                double[] weightd = null;
                if (!(this.xData instanceof DoubleStorage1D)) {
                    throw new RuntimeException("x-data storage is not a 1D array");
                }
                double[] xd = ((DoubleStorage1D)this.xData).getArray();
                if (!(this.yData instanceof DoubleStorage1D)) {
                    throw new RuntimeException("y-data storage is not a 1D array");
                }
                double[] yd = ((DoubleStorage1D)this.yData).getArray();
                if (!(this.weight instanceof DoubleStorage1D)) {
                    throw new RuntimeException("weight-data storage is not a 1D array");
                }
                weightd = ((DoubleStorage1D)this.weight).getArray();
                for (int i4 = 0; i4 < yd.length; ++i4) {
                    ss += MathBase.sqr((yd[i4] - g1.getValue(xd[i4])) / weightd[i4]);
                }
            } else {
                FunctionND g2 = (FunctionND)regFun;
                double[] xd = new double[this.xData.getValueDimension()];
                double[] yd = new double[this.yData.getValueDimension()];
                double[] weightd = new double[this.yData.getValueDimension()];
                for (int i5 = 0; i5 < this.xData.getLocalStorageDim(); ++i5) {
                    xd = this.xData.getLocal(i5);
                    yd = this.yData.getLocal(i5);
                    weightd = this.weight.getLocal(i5);
                    double[] ysim = g2.getValue(xd);
                    int vlength = ysim.length;
                    for (int index = 0; index < vlength; ++index) {
                        ss += MathBase.sqr((yd[index] - ysim[index]) / weightd[index]);
                    }
                }
            }
            this.lastSSnoConstraint = ss;
            if (regFun instanceof Function) {
                ((Function)regFun).setFitterMode(false);
            }
        }
        return ss;
    }

    protected static double halfWidth(double[] xData, double[] yData) {
        double ymax = yData[0];
        int imax = 0;
        int n = xData.length;
        for (int i = 1; i < n; ++i) {
            if (!(yData[i] > ymax)) continue;
            ymax = yData[i];
            imax = i;
        }
        ymax /= 2.0;
        double halflow = -1.0;
        double temp = -1.0;
        int ihl = -1;
        if (imax > 0) {
            ihl = imax - 1;
            halflow = Math.abs(ymax - yData[ihl]);
            for (int i = imax - 2; i >= 0; --i) {
                temp = Math.abs(ymax - yData[i]);
                if (!(temp < halflow)) continue;
                halflow = temp;
                ihl = i;
            }
            halflow = Math.abs(xData[ihl] - xData[imax]);
        }
        double halfhigh = -1.0;
        temp = -1.0;
        int ihh = -1;
        if (imax < n - 1) {
            ihh = imax + 1;
            halfhigh = Math.abs(ymax - yData[ihh]);
            for (int i = imax + 2; i < n; ++i) {
                temp = Math.abs(ymax - yData[i]);
                if (!(temp < halfhigh)) continue;
                halfhigh = temp;
                ihh = i;
            }
            halfhigh = Math.abs(xData[ihh] - xData[imax]);
        }
        double halfw = 0.0;
        int nd = 0;
        if (ihl != -1) {
            halfw += halflow;
            ++nd;
        }
        if (ihh != -1) {
            halfw += halfhigh;
            ++nd;
        }
        if (nd == 0) {
            return Double.NaN;
        }
        return halfw /= (double)nd;
    }

    public static double[][] histogramBins(double[] data, double binWidth, double binZero) {
        double dmax = Math.maximum(data);
        int nBins = (int)Math.ceil((dmax - binZero) / binWidth);
        if (binZero + (double)nBins * binWidth > dmax) {
            ++nBins;
        }
        int nPoints = data.length;
        int[] dataCheck = new int[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            dataCheck[i] = 0;
        }
        double[] binWall = new double[nBins + 1];
        binWall[0] = binZero;
        for (int i = 1; i <= nBins; ++i) {
            binWall[i] = binWall[i - 1] + binWidth;
        }
        double[][] binFreq = new double[2][nBins];
        for (int i = 0; i < nBins; ++i) {
            binFreq[0][i] = (binWall[i] + binWall[i + 1]) / 2.0;
            binFreq[1][i] = 0.0;
        }
        boolean test = true;
        for (int i = 0; i < nPoints; ++i) {
            test = true;
            int j = 0;
            while (test) {
                if (j == nBins - 1) {
                    if (data[i] >= binWall[j] && data[i] <= binWall[j + 1] * (1.0 + NonLinearRegressionFitter.histTol)) {
                        double[] dArray = binFreq[1];
                        int n = j;
                        dArray[n] = dArray[n] + 1.0;
                        dataCheck[i] = 1;
                        test = false;
                    }
                } else if (data[i] >= binWall[j] && data[i] < binWall[j + 1]) {
                    double[] dArray = binFreq[1];
                    int n = j;
                    dArray[n] = dArray[n] + 1.0;
                    dataCheck[i] = 1;
                    test = false;
                }
                if (!test) continue;
                if (j == nBins - 1) {
                    test = false;
                    continue;
                }
                ++j;
            }
        }
        int nMissed = 0;
        for (int i = 0; i < nPoints; ++i) {
            if (dataCheck[i] != 0) continue;
            ++nMissed;
            System.out.println("p " + i + " " + data[i] + " " + binWall[0] + " " + binWall[nBins]);
        }
        if (nMissed > 0) {
            System.out.println(nMissed + " data points, outside histogram limits, excluded in histogramBins");
        }
        return binFreq;
    }

    public static double[][] histogramBins(double[] data, double binWidth, double binZero, double binUpper) {
        int n = 0;
        int m = data.length;
        for (int i = 0; i < m; ++i) {
            if (!(data[i] <= binUpper)) continue;
            ++n;
        }
        if (n != m) {
            double[] newData = new double[n];
            int j = 0;
            for (int i = 0; i < m; ++i) {
                if (!(data[i] <= binUpper)) continue;
                newData[j] = data[i];
                ++j;
            }
            System.out.println(m - n + " data points, above histogram upper limit, excluded in histogramBins");
            return NonLinearRegressionFitter2.histogramBins(newData, binWidth, binZero);
        }
        return NonLinearRegressionFitter2.histogramBins(data, binWidth, binZero);
    }

    protected static boolean setTrueFreqWeights(VoxelArrayND yData, VoxelArrayND weight) {
        int ii;
        boolean flag = true;
        for (ii = 0; ii < yData.getLocalStorageDim(); ++ii) {
        }
        for (ii = 0; ii < yData.getLocalStorageDim(); ++ii) {
            double last = 0.0;
            double d = 0.0;
        }
        return true;
    }

    protected static void sort(double[] x, double[] y, double[] w) {
        int index = 0;
        int lastIndex = -1;
        int n = x.length;
        double holdx = 0.0;
        double holdy = 0.0;
        double holdw = 0.0;
        while (lastIndex < n - 1) {
            index = lastIndex + 1;
            for (int i = lastIndex + 2; i < n; ++i) {
                if (!(x[i] < x[index])) continue;
                index = i;
            }
            holdx = x[index];
            x[index] = x[++lastIndex];
            x[lastIndex] = holdx;
            holdy = y[index];
            y[index] = y[lastIndex];
            y[lastIndex] = holdy;
            holdw = w[index];
            w[index] = w[lastIndex];
            w[lastIndex] = holdw;
        }
    }
}

