/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.filter.iir;

import io.fair_acc.math.filter.iir.ComplexPair;
import io.fair_acc.math.filter.iir.LayoutBase;
import io.fair_acc.math.filter.iir.PoleZeroPair;
import org.apache.commons.math3.complex.Complex;

public final class BandPassTransform {
    private BandPassTransform() {
    }

    public static void transform(double fc, double fw, LayoutBase digital, LayoutBase analog) {
        digital.reset();
        double ww = Math.PI * 2 * fw;
        double wc2 = Math.PI * 2 * fc - ww / 2.0;
        double wc = wc2 + ww;
        if (wc2 < 1.0E-8) {
            wc2 = 1.0E-8;
        }
        if (wc > 3.141592643589793) {
            wc = 3.141592643589793;
        }
        double a = Math.cos((wc + wc2) * 0.5) / Math.cos((wc - wc2) * 0.5);
        double b = 1.0 / Math.tan((wc - wc2) * 0.5);
        int numPoles = analog.getNumPoles();
        int pairs = numPoles / 2;
        for (int i = 0; i < pairs; ++i) {
            PoleZeroPair pair = analog.getPair(i);
            ComplexPair p1 = BandPassTransform.transform(pair.poles.first, a, b);
            ComplexPair z1 = BandPassTransform.transform(pair.zeros.first, a, b);
            digital.addPoleZeroConjugatePairs(p1.first, z1.first);
            digital.addPoleZeroConjugatePairs(p1.second, z1.second);
        }
        if ((numPoles & 1) == 1) {
            ComplexPair poles = BandPassTransform.transform(analog.getPair((int)pairs).poles.first, a, b);
            ComplexPair zeros = BandPassTransform.transform(analog.getPair((int)pairs).zeros.first, a, b);
            digital.add(poles, zeros);
        }
        double wn = analog.getNormalW();
        digital.setNormal(2.0 * Math.atan(Math.sqrt(Math.tan((wc + wn) * 0.5) * Math.tan((wc2 + wn) * 0.5))), analog.getNormalGain());
    }

    private static ComplexPair transform(Complex in, double a, double b) {
        if (in.isInfinite()) {
            return new ComplexPair(new Complex(-1.0), new Complex(1.0));
        }
        Complex c = new Complex(1.0).add(in).divide(new Complex(1.0).subtract(in));
        double a2 = a * a;
        double b2 = b * b;
        double ab = a * b;
        double ab2 = 2.0 * ab;
        Complex v = new Complex(0.0).add(c.multiply(4.0 * (b2 * (a2 - 1.0) + 1.0)));
        v = v.add(8.0 * (b2 * (a2 - 1.0) - 1.0));
        v = v.multiply(c);
        v = v.add(4.0 * (b2 * (a2 - 1.0) + 1.0));
        v = v.sqrt();
        Complex u = v.multiply(-1).add(c.multiply(ab2)).add(ab2);
        v = v.add(c.multiply(ab2)).add(ab2);
        Complex d = new Complex(0.0).add(c.multiply(2.0 * (b - 1.0))).add(2.0 * (1.0 + b));
        return new ComplexPair(u.divide(d), v.divide(d));
    }
}

