/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Function;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.openshift.api.model.DoneableProjectRequest;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.ProjectRequestOperation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class ProjectRequestsOperationImpl
extends OperationSupport
implements ProjectRequestOperation {
    private final ProjectRequest item;

    public ProjectRequestsOperationImpl(OkHttpClient client, OpenShiftConfig config) {
        this(client, config, null, null);
    }

    public ProjectRequestsOperationImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, ProjectRequest item) {
        super(client, (Config)config, null, apiVersion, "projectrequests", null, null);
        this.item = item;
    }

    public boolean isResourceNamespaced() {
        return false;
    }

    public URL getRootUrl() {
        try {
            return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public ProjectRequest create(ProjectRequest ... resources) {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return (ProjectRequest)this.handleCreate(resources[0], ProjectRequest.class);
            }
            if (this.getItem() == null) {
                throw new IllegalArgumentException("Nothing to create.");
            }
            return (ProjectRequest)this.handleCreate(this.getItem(), ProjectRequest.class);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public DoneableProjectRequest createNew() {
        return new DoneableProjectRequest((Function)new Function<ProjectRequest, ProjectRequest>(){

            public ProjectRequest apply(ProjectRequest item) {
                try {
                    return ProjectRequestsOperationImpl.this.create(item);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable((Throwable)e);
                }
            }
        });
    }

    public Status list() {
        try {
            URL requestUrl = this.getNamespacedUrl();
            Request.Builder requestBuilder = new Request.Builder().get().url(requestUrl);
            return (Status)this.handleResponse(requestBuilder, Status.class);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public ProjectRequest getItem() {
        return this.item;
    }
}

