/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableStatus;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusFluent;
import io.fabric8.kubernetes.api.model.StatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class StatusBuilder
extends StatusFluentImpl<StatusBuilder>
implements VisitableBuilder<Status, StatusBuilder> {
    StatusFluent<?> fluent;

    public StatusBuilder() {
        this(new Status());
    }

    public StatusBuilder(StatusFluent<?> fluent) {
        this(fluent, new Status());
    }

    public StatusBuilder(StatusFluent<?> fluent, Status instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withCode(instance.getCode());
        fluent.withDetails(instance.getDetails());
        fluent.withKind(instance.getKind());
        fluent.withMessage(instance.getMessage());
        fluent.withMetadata(instance.getMetadata());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
    }

    public StatusBuilder(Status instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withCode(instance.getCode());
        this.withDetails(instance.getDetails());
        this.withKind(instance.getKind());
        this.withMessage(instance.getMessage());
        this.withMetadata(instance.getMetadata());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
    }

    public EditableStatus build() {
        EditableStatus buildable = new EditableStatus(this.fluent.getApiVersion(), this.fluent.getCode(), this.fluent.getDetails(), this.fluent.getKind(), this.fluent.getMessage(), this.fluent.getMetadata(), this.fluent.getReason(), this.fluent.getStatus());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatusBuilder that = (StatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

