/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableRBDVolumeSource;
import io.fabric8.kubernetes.api.model.RBDVolumeSource;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class RBDVolumeSourceBuilder
extends RBDVolumeSourceFluentImpl<RBDVolumeSourceBuilder>
implements VisitableBuilder<RBDVolumeSource, RBDVolumeSourceBuilder> {
    RBDVolumeSourceFluent<?> fluent;

    public RBDVolumeSourceBuilder() {
        this(new RBDVolumeSource());
    }

    public RBDVolumeSourceBuilder(RBDVolumeSourceFluent<?> fluent) {
        this(fluent, new RBDVolumeSource());
    }

    public RBDVolumeSourceBuilder(RBDVolumeSourceFluent<?> fluent, RBDVolumeSource instance) {
        this.fluent = fluent;
        fluent.withFsType(instance.getFsType());
        fluent.withImage(instance.getImage());
        fluent.withKeyring(instance.getKeyring());
        fluent.withMonitors(instance.getMonitors());
        fluent.withPool(instance.getPool());
        fluent.withReadOnly(instance.getReadOnly());
        fluent.withSecretRef(instance.getSecretRef());
        fluent.withUser(instance.getUser());
    }

    public RBDVolumeSourceBuilder(RBDVolumeSource instance) {
        this.fluent = this;
        this.withFsType(instance.getFsType());
        this.withImage(instance.getImage());
        this.withKeyring(instance.getKeyring());
        this.withMonitors(instance.getMonitors());
        this.withPool(instance.getPool());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withUser(instance.getUser());
    }

    public EditableRBDVolumeSource build() {
        EditableRBDVolumeSource buildable = new EditableRBDVolumeSource(this.fluent.getFsType(), this.fluent.getImage(), this.fluent.getKeyring(), this.fluent.getMonitors(), this.fluent.getPool(), this.fluent.isReadOnly(), this.fluent.getSecretRef(), this.fluent.getUser());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RBDVolumeSourceBuilder that = (RBDVolumeSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

