/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.SELinuxOptions;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractPodSecurityContextAssert<S extends AbstractPodSecurityContextAssert<S, A>, A extends PodSecurityContext>
extends AbstractAssert<S, A> {
    protected AbstractPodSecurityContextAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((PodSecurityContext)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractPodSecurityContextAssert)this.myself));
    }

    public S hasFsGroup(Long fsGroup) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fsGroup of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualFsGroup = ((PodSecurityContext)this.actual).getFsGroup();
        if (!Objects.areEqual((Object)actualFsGroup, (Object)fsGroup)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fsGroup, actualFsGroup});
        }
        return (S)((Object)((AbstractPodSecurityContextAssert)this.myself));
    }

    public S hasRunAsNonRoot(Boolean runAsNonRoot) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting runAsNonRoot of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Boolean actualRunAsNonRoot = ((PodSecurityContext)this.actual).getRunAsNonRoot();
        if (!Objects.areEqual((Object)actualRunAsNonRoot, (Object)runAsNonRoot)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, runAsNonRoot, actualRunAsNonRoot});
        }
        return (S)((Object)((AbstractPodSecurityContextAssert)this.myself));
    }

    public S hasRunAsUser(Long runAsUser) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting runAsUser of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualRunAsUser = ((PodSecurityContext)this.actual).getRunAsUser();
        if (!Objects.areEqual((Object)actualRunAsUser, (Object)runAsUser)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, runAsUser, actualRunAsUser});
        }
        return (S)((Object)((AbstractPodSecurityContextAssert)this.myself));
    }

    public S hasSeLinuxOptions(SELinuxOptions seLinuxOptions) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting seLinuxOptions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SELinuxOptions actualSeLinuxOptions = ((PodSecurityContext)this.actual).getSeLinuxOptions();
        if (!Objects.areEqual((Object)actualSeLinuxOptions, (Object)seLinuxOptions)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, seLinuxOptions, actualSeLinuxOptions});
        }
        return (S)((Object)((AbstractPodSecurityContextAssert)this.myself));
    }

    public S hasSupplementalGroups(Long ... supplementalGroups) {
        this.isNotNull();
        if (supplementalGroups == null) {
            this.failWithMessage("Expecting supplementalGroups parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((PodSecurityContext)this.actual).getSupplementalGroups(), (Object[])supplementalGroups);
        return (S)((Object)((AbstractPodSecurityContextAssert)this.myself));
    }

    public S hasOnlySupplementalGroups(Long ... supplementalGroups) {
        this.isNotNull();
        if (supplementalGroups == null) {
            this.failWithMessage("Expecting supplementalGroups parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((PodSecurityContext)this.actual).getSupplementalGroups(), (Object[])supplementalGroups);
        return (S)((Object)((AbstractPodSecurityContextAssert)this.myself));
    }

    public S doesNotHaveSupplementalGroups(Long ... supplementalGroups) {
        this.isNotNull();
        if (supplementalGroups == null) {
            this.failWithMessage("Expecting supplementalGroups parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((PodSecurityContext)this.actual).getSupplementalGroups(), (Object[])supplementalGroups);
        return (S)((Object)((AbstractPodSecurityContextAssert)this.myself));
    }

    public S hasNoSupplementalGroups() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have supplementalGroups but had :\n  <%s>";
        if (((PodSecurityContext)this.actual).getSupplementalGroups().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((PodSecurityContext)this.actual).getSupplementalGroups()});
        }
        return (S)((Object)((AbstractPodSecurityContextAssert)this.myself));
    }
}

