/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.NodeCondition;
import io.fabric8.kubernetes.api.model.NodeDaemonEndpoints;
import io.fabric8.kubernetes.api.model.NodeStatusFluentImpl;
import io.fabric8.kubernetes.api.model.NodeSystemInfo;
import io.fabric8.kubernetes.api.model.Quantity;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractNodeStatusFluentImplAssert<S extends AbstractNodeStatusFluentImplAssert<S, A>, A extends NodeStatusFluentImpl>
extends AbstractAssert<S, A> {
    protected AbstractNodeStatusFluentImplAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((NodeStatusFluentImpl)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractNodeStatusFluentImplAssert)this.myself));
    }

    public S hasAddresses(NodeAddress ... addresses) {
        this.isNotNull();
        if (addresses == null) {
            this.failWithMessage("Expecting addresses parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((NodeStatusFluentImpl)this.actual).getAddresses(), (Object[])addresses);
        return (S)((Object)((AbstractNodeStatusFluentImplAssert)this.myself));
    }

    public S hasOnlyAddresses(NodeAddress ... addresses) {
        this.isNotNull();
        if (addresses == null) {
            this.failWithMessage("Expecting addresses parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((NodeStatusFluentImpl)this.actual).getAddresses(), (Object[])addresses);
        return (S)((Object)((AbstractNodeStatusFluentImplAssert)this.myself));
    }

    public S doesNotHaveAddresses(NodeAddress ... addresses) {
        this.isNotNull();
        if (addresses == null) {
            this.failWithMessage("Expecting addresses parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((NodeStatusFluentImpl)this.actual).getAddresses(), (Object[])addresses);
        return (S)((Object)((AbstractNodeStatusFluentImplAssert)this.myself));
    }

    public S hasNoAddresses() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have addresses but had :\n  <%s>";
        if (((NodeStatusFluentImpl)this.actual).getAddresses().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((NodeStatusFluentImpl)this.actual).getAddresses()});
        }
        return (S)((Object)((AbstractNodeStatusFluentImplAssert)this.myself));
    }

    public S hasCapacity(Map capacity) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting capacity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Quantity> actualCapacity = ((NodeStatusFluentImpl)this.actual).getCapacity();
        if (!Objects.areEqual(actualCapacity, (Object)capacity)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, capacity, actualCapacity});
        }
        return (S)((Object)((AbstractNodeStatusFluentImplAssert)this.myself));
    }

    public S hasConditions(NodeCondition ... conditions) {
        this.isNotNull();
        if (conditions == null) {
            this.failWithMessage("Expecting conditions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((NodeStatusFluentImpl)this.actual).getConditions(), (Object[])conditions);
        return (S)((Object)((AbstractNodeStatusFluentImplAssert)this.myself));
    }

    public S hasOnlyConditions(NodeCondition ... conditions) {
        this.isNotNull();
        if (conditions == null) {
            this.failWithMessage("Expecting conditions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((NodeStatusFluentImpl)this.actual).getConditions(), (Object[])conditions);
        return (S)((Object)((AbstractNodeStatusFluentImplAssert)this.myself));
    }

    public S doesNotHaveConditions(NodeCondition ... conditions) {
        this.isNotNull();
        if (conditions == null) {
            this.failWithMessage("Expecting conditions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((NodeStatusFluentImpl)this.actual).getConditions(), (Object[])conditions);
        return (S)((Object)((AbstractNodeStatusFluentImplAssert)this.myself));
    }

    public S hasNoConditions() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have conditions but had :\n  <%s>";
        if (((NodeStatusFluentImpl)this.actual).getConditions().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((NodeStatusFluentImpl)this.actual).getConditions()});
        }
        return (S)((Object)((AbstractNodeStatusFluentImplAssert)this.myself));
    }

    public S hasDaemonEndpoints(NodeDaemonEndpoints daemonEndpoints) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting daemonEndpoints of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        NodeDaemonEndpoints actualDaemonEndpoints = ((NodeStatusFluentImpl)this.actual).getDaemonEndpoints();
        if (!Objects.areEqual((Object)actualDaemonEndpoints, (Object)daemonEndpoints)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, daemonEndpoints, actualDaemonEndpoints});
        }
        return (S)((Object)((AbstractNodeStatusFluentImplAssert)this.myself));
    }

    public S hasNodeInfo(NodeSystemInfo nodeInfo) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting nodeInfo of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        NodeSystemInfo actualNodeInfo = ((NodeStatusFluentImpl)this.actual).getNodeInfo();
        if (!Objects.areEqual((Object)actualNodeInfo, (Object)nodeInfo)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, nodeInfo, actualNodeInfo});
        }
        return (S)((Object)((AbstractNodeStatusFluentImplAssert)this.myself));
    }

    public S hasPhase(String phase) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting phase of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualPhase = ((NodeStatusFluentImpl)this.actual).getPhase();
        if (!Objects.areEqual((Object)actualPhase, (Object)phase)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, phase, actualPhase});
        }
        return (S)((Object)((AbstractNodeStatusFluentImplAssert)this.myself));
    }
}

