/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.jackson;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

public class JacksonMessageBodyProvider
extends JacksonJaxbJsonProvider {
    private final ObjectMapper mapper;

    public JacksonMessageBodyProvider(ObjectMapper mapper) {
        this.mapper = mapper;
        this.setMapper(mapper);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isProvidable(type) && super.isReadable(type, genericType, annotations, mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isProvidable(type) && super.isWriteable(type, genericType, annotations, mediaType);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            return super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
        }
        catch (IOException e) {
            if (e instanceof JsonProcessingException) {
                throw e;
            }
            throw JsonMappingException.fromUnexpectedIOE((IOException)e);
        }
    }

    private boolean isProvidable(Class<?> type) {
        JsonIgnoreType ignore = type.getAnnotation(JsonIgnoreType.class);
        return ignore == null || !ignore.value();
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }
}

