/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.operation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.operation.AddOperation;
import com.github.fge.jsonpatch.operation.DualPathOperation;

public final class CopyOperation
extends DualPathOperation {
    public static final String OPERATION_NAME = "copy";

    @JsonCreator
    public CopyOperation(@JsonProperty(value="from") JsonPointer from, @JsonProperty(value="path") JsonPointer path) {
        super(OPERATION_NAME, from, path);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        JsonNode dupData = ((JsonNode)this.from.path((TreeNode)node)).deepCopy();
        if (dupData.isMissingNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchPath"));
        }
        return new AddOperation(this.getPath(), dupData).apply(node);
    }
}

