/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.types;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StructField;
import java.util.Objects;

@Evolving
public class MapType
extends DataType {
    private final StructField keyField;
    private final StructField valueField;

    public MapType(DataType dataType, DataType dataType2, boolean bl) {
        this.keyField = new StructField("key", dataType, false);
        this.valueField = new StructField("value", dataType2, bl);
    }

    public MapType(StructField structField, StructField structField2) {
        this.keyField = structField;
        this.valueField = structField2;
    }

    public StructField getKeyField() {
        return this.keyField;
    }

    public StructField getValueField() {
        return this.valueField;
    }

    public DataType getKeyType() {
        return this.getKeyField().getDataType();
    }

    public DataType getValueType() {
        return this.getValueField().getDataType();
    }

    public boolean isValueContainsNull() {
        return this.valueField.isNullable();
    }

    @Override
    public boolean equivalent(DataType dataType) {
        return dataType instanceof MapType && ((MapType)dataType).getKeyType().equivalent(this.getKeyType()) && ((MapType)dataType).getValueType().equivalent(this.getValueType()) && ((MapType)dataType).isValueContainsNull() == this.isValueContainsNull();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MapType mapType = (MapType)object;
        return Objects.equals(this.keyField, mapType.keyField) && Objects.equals(this.valueField, mapType.valueField);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keyField, this.valueField);
    }

    @Override
    public String toString() {
        return String.format("map[%s, %s]", this.getKeyType(), this.getValueType());
    }
}

