/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.util.Iterator;

@Evolving
public class Utils {
    public static <T> CloseableIterator<T> singletonCloseableIterator(final T t) {
        return new CloseableIterator<T>(){
            private boolean accessed;

            @Override
            public void close() throws IOException {
            }

            @Override
            public boolean hasNext() {
                return !this.accessed;
            }

            @Override
            public T next() {
                this.accessed = true;
                return t;
            }
        };
    }

    public static <T> CloseableIterator<T> toCloseableIterator(final Iterator<T> iterator) {
        return new CloseableIterator<T>(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    public static void closeCloseables(AutoCloseable ... autoCloseableArray) {
        Throwable throwable = null;
        for (AutoCloseable autoCloseable : autoCloseableArray) {
            if (autoCloseable == null) continue;
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                if (throwable == null) {
                    throwable = new RuntimeException(exception);
                    continue;
                }
                throwable.addSuppressed(exception);
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    public static void closeCloseablesSilently(AutoCloseable ... autoCloseableArray) {
        try {
            Utils.closeCloseables(autoCloseableArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

