/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.data;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.data.StructRow;
import io.delta.kernel.types.StructType;
import java.math.BigDecimal;

public abstract class ChildVectorBasedRow
implements Row {
    private final int rowId;
    private final StructType schema;

    public ChildVectorBasedRow(int n, StructType structType) {
        this.rowId = n;
        this.schema = structType;
    }

    @Override
    public StructType getSchema() {
        return this.schema;
    }

    @Override
    public boolean isNullAt(int n) {
        return this.getChild(n).isNullAt(this.rowId);
    }

    @Override
    public boolean getBoolean(int n) {
        return this.getChild(n).getBoolean(this.rowId);
    }

    @Override
    public byte getByte(int n) {
        return this.getChild(n).getByte(this.rowId);
    }

    @Override
    public short getShort(int n) {
        return this.getChild(n).getShort(this.rowId);
    }

    @Override
    public int getInt(int n) {
        return this.getChild(n).getInt(this.rowId);
    }

    @Override
    public long getLong(int n) {
        return this.getChild(n).getLong(this.rowId);
    }

    @Override
    public float getFloat(int n) {
        return this.getChild(n).getFloat(this.rowId);
    }

    @Override
    public double getDouble(int n) {
        return this.getChild(n).getDouble(this.rowId);
    }

    @Override
    public String getString(int n) {
        return this.getChild(n).getString(this.rowId);
    }

    @Override
    public BigDecimal getDecimal(int n) {
        return this.getChild(n).getDecimal(this.rowId);
    }

    @Override
    public byte[] getBinary(int n) {
        return this.getChild(n).getBinary(this.rowId);
    }

    @Override
    public Row getStruct(int n) {
        return StructRow.fromStructVector(this.getChild(n), this.rowId);
    }

    @Override
    public ArrayValue getArray(int n) {
        return this.getChild(n).getArray(this.rowId);
    }

    @Override
    public MapValue getMap(int n) {
        return this.getChild(n).getMap(this.rowId);
    }

    protected abstract ColumnVector getChild(int var1);
}

