/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.checkpoints;

import io.delta.kernel.data.Row;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.StructType;
import java.util.HashMap;
import java.util.Optional;

public class CheckpointMetaData {
    public static StructType READ_SCHEMA = new StructType().add("version", (DataType)LongType.LONG, false).add("size", (DataType)LongType.LONG, false).add("parts", LongType.LONG);
    public final long version;
    public final long size;
    public final Optional<Long> parts;

    public static CheckpointMetaData fromRow(Row row) {
        return new CheckpointMetaData(row.getLong(0), row.getLong(1), row.isNullAt(2) ? Optional.empty() : Optional.of(row.getLong(2)));
    }

    public CheckpointMetaData(long l, long l2, Optional<Long> optional) {
        this.version = l;
        this.size = l2;
        this.parts = optional;
    }

    public Row toRow() {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(0, this.version);
        hashMap.put(1, this.size);
        this.parts.ifPresent(l -> hashMap.put(2, l));
        return new GenericRow(READ_SCHEMA, hashMap);
    }

    public String toString() {
        return "CheckpointMetaData{version=" + this.version + ", size=" + this.size + ", parts=" + this.parts + '}';
    }
}

