/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.expressions;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.types.DataType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Evolving
public class PartitionValueExpression
implements Expression {
    private final DataType partitionValueType;
    private final Expression serializedPartitionValue;

    public PartitionValueExpression(Expression expression, DataType dataType) {
        this.serializedPartitionValue = Objects.requireNonNull(expression);
        this.partitionValueType = Objects.requireNonNull(dataType);
    }

    public Expression getInput() {
        return this.serializedPartitionValue;
    }

    public DataType getDataType() {
        return this.partitionValueType;
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.singletonList(this.serializedPartitionValue);
    }

    public String toString() {
        return String.format("partition_value(%s, %s)", this.serializedPartitionValue, this.partitionValueType);
    }
}

