/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.data;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.data.ColumnarBatchRow;
import io.delta.kernel.utils.CloseableIterator;
import java.util.NoSuchElementException;
import java.util.Optional;

@Evolving
public class FilteredColumnarBatch {
    private final ColumnarBatch data;
    private final Optional<ColumnVector> selectionVector;

    public FilteredColumnarBatch(ColumnarBatch columnarBatch, Optional<ColumnVector> optional) {
        this.data = columnarBatch;
        this.selectionVector = optional;
    }

    public ColumnarBatch getData() {
        return this.data;
    }

    public Optional<ColumnVector> getSelectionVector() {
        return this.selectionVector;
    }

    public CloseableIterator<Row> getRows() {
        if (!this.selectionVector.isPresent()) {
            return this.data.getRows();
        }
        return new CloseableIterator<Row>(){
            private int rowId = 0;
            private int maxRowId = FilteredColumnarBatch.access$000(FilteredColumnarBatch.this).getSize();
            private int nextRowId = -1;

            @Override
            public boolean hasNext() {
                while (this.rowId < this.maxRowId && this.nextRowId == -1) {
                    boolean bl;
                    boolean bl2 = bl = !((ColumnVector)FilteredColumnarBatch.this.selectionVector.get()).isNullAt(this.rowId) && ((ColumnVector)FilteredColumnarBatch.this.selectionVector.get()).getBoolean(this.rowId);
                    if (bl) {
                        this.nextRowId = this.rowId++;
                        break;
                    }
                    ++this.rowId;
                }
                return this.nextRowId != -1;
            }

            @Override
            public Row next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ColumnarBatchRow columnarBatchRow = new ColumnarBatchRow(FilteredColumnarBatch.this.data, this.nextRowId);
                this.nextRowId = -1;
                return columnarBatchRow;
            }

            @Override
            public void close() {
            }
        };
    }
}

