/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.prometheus.model;

import io.dekorate.prometheus.model.Endpoint;
import io.dekorate.prometheus.model.EndpointBuilder;
import io.dekorate.prometheus.model.EndpointFluent;
import io.dekorate.prometheus.model.ServiceMonitorSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ServiceMonitorSpecFluent<A extends ServiceMonitorSpecFluent<A>>
extends BaseFluent<A> {
    private LabelSelectorBuilder selector;
    private ArrayList<EndpointBuilder> endpoints;

    public ServiceMonitorSpecFluent() {
    }

    public ServiceMonitorSpecFluent(ServiceMonitorSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceMonitorSpec instance) {
        ServiceMonitorSpec serviceMonitorSpec = instance = instance != null ? instance : new ServiceMonitorSpec();
        if (instance != null) {
            this.withSelector(instance.getSelector());
            this.withEndpoints(instance.getEndpoints());
        }
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.remove((Object)"selector");
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove(this.selector);
        }
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public A addToEndpoints(int index, Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        EndpointBuilder builder = new EndpointBuilder(item);
        if (index < 0 || index >= this.endpoints.size()) {
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        } else {
            this._visitables.get((Object)"endpoints").add(index, builder);
            this.endpoints.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEndpoints(int index, Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        EndpointBuilder builder = new EndpointBuilder(item);
        if (index < 0 || index >= this.endpoints.size()) {
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        } else {
            this._visitables.get((Object)"endpoints").set(index, builder);
            this.endpoints.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEndpoints(Endpoint ... items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEndpoints(Collection<Endpoint> items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEndpoints(Endpoint ... items) {
        if (this.endpoints == null) {
            return (A)((Object)this);
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get((Object)"endpoints").remove((Object)builder);
            this.endpoints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEndpoints(Collection<Endpoint> items) {
        if (this.endpoints == null) {
            return (A)((Object)this);
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get((Object)"endpoints").remove((Object)builder);
            this.endpoints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEndpoints(Predicate<EndpointBuilder> predicate) {
        if (this.endpoints == null) {
            return (A)((Object)this);
        }
        Iterator<EndpointBuilder> each = this.endpoints.iterator();
        List visitables = this._visitables.get((Object)"endpoints");
        while (each.hasNext()) {
            EndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Endpoint> buildEndpoints() {
        return this.endpoints != null ? ServiceMonitorSpecFluent.build(this.endpoints) : null;
    }

    public Endpoint buildEndpoint(int index) {
        return this.endpoints.get(index).build();
    }

    public Endpoint buildFirstEndpoint() {
        return this.endpoints.get(0).build();
    }

    public Endpoint buildLastEndpoint() {
        return this.endpoints.get(this.endpoints.size() - 1).build();
    }

    public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEndpoints(List<Endpoint> endpoints) {
        if (this.endpoints != null) {
            this._visitables.get((Object)"endpoints").clear();
        }
        if (endpoints != null) {
            this.endpoints = new ArrayList();
            for (Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        } else {
            this.endpoints = null;
        }
        return (A)((Object)this);
    }

    public A withEndpoints(Endpoint ... endpoints) {
        if (this.endpoints != null) {
            this.endpoints.clear();
            this._visitables.remove((Object)"endpoints");
        }
        if (endpoints != null) {
            for (Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEndpoints() {
        return this.endpoints != null && !this.endpoints.isEmpty();
    }

    public EndpointsNested<A> addNewEndpoint() {
        return new EndpointsNested(-1, null);
    }

    public EndpointsNested<A> addNewEndpointLike(Endpoint item) {
        return new EndpointsNested(-1, item);
    }

    public EndpointsNested<A> setNewEndpointLike(int index, Endpoint item) {
        return new EndpointsNested(index, item);
    }

    public EndpointsNested<A> editEndpoint(int index) {
        if (this.endpoints.size() <= index) {
            throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public EndpointsNested<A> editFirstEndpoint() {
        if (this.endpoints.size() == 0) {
            throw new RuntimeException("Can't edit first endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(0, this.buildEndpoint(0));
    }

    public EndpointsNested<A> editLastEndpoint() {
        int index = this.endpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            if (!predicate.test(this.endpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching endpoints. No match found.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceMonitorSpecFluent that = (ServiceMonitorSpecFluent)((Object)o);
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        return Objects.equals(this.endpoints, that.endpoints);
    }

    public int hashCode() {
        return Objects.hash(this.selector, this.endpoints, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.endpoints != null && !this.endpoints.isEmpty()) {
            sb.append("endpoints:");
            sb.append(this.endpoints);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EndpointsNested<N>
    extends EndpointFluent<EndpointsNested<N>>
    implements Nested<N> {
        EndpointBuilder builder;
        int index;

        EndpointsNested(int index, Endpoint item) {
            this.index = index;
            this.builder = new EndpointBuilder(this, item);
        }

        public N and() {
            return (N)ServiceMonitorSpecFluent.this.setToEndpoints(this.index, this.builder.build());
        }

        public N endEndpoint() {
            return this.and();
        }
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)ServiceMonitorSpecFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }
}

