/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.config;

import io.dekorate.kubernetes.config.BaseConfigFluentImpl;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.ContainerFluent;
import io.dekorate.kubernetes.config.ContainerFluentImpl;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.openshift.config.OpenshiftConfigFluent;
import io.dekorate.openshift.config.Route;
import io.dekorate.openshift.config.RouteBuilder;
import io.dekorate.openshift.config.RouteFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class OpenshiftConfigFluentImpl<A extends OpenshiftConfigFluent<A>>
extends BaseConfigFluentImpl<A>
implements OpenshiftConfigFluent<A> {
    private ArrayList<ContainerBuilder> initContainers = new ArrayList();
    private Integer replicas;
    private RouteBuilder route;
    private Boolean headless;

    public OpenshiftConfigFluentImpl() {
    }

    public OpenshiftConfigFluentImpl(OpenshiftConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withPartOf(instance.getPartOf());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withDeploymentKind(instance.getDeploymentKind());
        this.withLabels(instance.getLabels());
        this.withAnnotations(instance.getAnnotations());
        this.withEnvVars(instance.getEnvVars());
        this.withWorkingDir(instance.getWorkingDir());
        this.withCommand(instance.getCommand());
        this.withArguments(instance.getArguments());
        this.withServiceAccount(instance.getServiceAccount());
        this.withPorts(instance.getPorts());
        this.withServiceType(instance.getServiceType());
        this.withPvcVolumes(instance.getPvcVolumes());
        this.withSecretVolumes(instance.getSecretVolumes());
        this.withConfigMapVolumes(instance.getConfigMapVolumes());
        this.withEmptyDirVolumes(instance.getEmptyDirVolumes());
        this.withGitRepoVolumes(instance.getGitRepoVolumes());
        this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
        this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
        this.withAzureFileVolumes(instance.getAzureFileVolumes());
        this.withMounts(instance.getMounts());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withHostAliases(instance.getHostAliases());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withStartupProbe(instance.getStartupProbe());
        this.withRequestResources(instance.getRequestResources());
        this.withLimitResources(instance.getLimitResources());
        this.withSidecars(instance.getSidecars());
        this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
        this.withJobs(instance.getJobs());
        this.withCronJobs(instance.getCronJobs());
        this.withInitContainers(instance.getInitContainers());
        this.withReplicas(instance.getReplicas());
        this.withRoute(instance.getRoute());
        this.withHeadless(instance.getHeadless());
    }

    @Override
    public A withInitContainers(Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
        }
        if (initContainers != null) {
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Container[] getInitContainers() {
        int size = this.initContainers != null ? this.initContainers.size() : 0;
        Container[] result = new Container[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.initContainers) {
            result[index++] = (Container)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Container[] buildInitContainers() {
        int size = this.initContainers != null ? this.initContainers.size() : 0;
        Container[] result = new Container[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.initContainers) {
            result[index++] = (Container)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Container buildInitContainer(Integer index) {
        return this.initContainers.get(index).build();
    }

    @Override
    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    @Override
    public Container buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    @Override
    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToInitContainers(Integer index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get((Object)"initContainers").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"initContainers").size(), builder);
        this.initContainers.add(index >= 0 ? index.intValue() : this.initContainers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInitContainers(Integer index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"initContainers").size()) {
            this._visitables.get((Object)"initContainers").add(builder);
        } else {
            this._visitables.get((Object)"initContainers").set(index, builder);
        }
        if (index < 0 || index >= this.initContainers.size()) {
            this.initContainers.add(builder);
        } else {
            this.initContainers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitContainers(Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.initContainers.iterator();
        List visitables = this._visitables.get((Object)"initContainers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    @Override
    public OpenshiftConfigFluent.InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNestedImpl();
    }

    @Override
    public OpenshiftConfigFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNestedImpl(-1, item);
    }

    @Override
    public OpenshiftConfigFluent.InitContainersNested<A> setNewInitContainerLike(Integer index, Container item) {
        return new InitContainersNestedImpl(index, item);
    }

    @Override
    public OpenshiftConfigFluent.InitContainersNested<A> editInitContainer(Integer index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public OpenshiftConfigFluent.InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    @Override
    public OpenshiftConfigFluent.InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public OpenshiftConfigFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.test(this.initContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    @Deprecated
    public Route getRoute() {
        return this.route != null ? this.route.build() : null;
    }

    @Override
    public Route buildRoute() {
        return this.route != null ? this.route.build() : null;
    }

    @Override
    public A withRoute(Route route) {
        this._visitables.get((Object)"route").remove(this.route);
        if (route != null) {
            this.route = new RouteBuilder(route);
            this._visitables.get((Object)"route").add(this.route);
        } else {
            this.route = null;
            this._visitables.get((Object)"route").remove(this.route);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoute() {
        return this.route != null;
    }

    @Override
    public A withNewRoute(Boolean expose, String host, String targetPort) {
        return this.withRoute(new Route(expose, host, targetPort));
    }

    @Override
    public OpenshiftConfigFluent.RouteNested<A> withNewRoute() {
        return new RouteNestedImpl();
    }

    @Override
    public OpenshiftConfigFluent.RouteNested<A> withNewRouteLike(Route item) {
        return new RouteNestedImpl(item);
    }

    @Override
    public OpenshiftConfigFluent.RouteNested<A> editRoute() {
        return this.withNewRouteLike(this.getRoute());
    }

    @Override
    public OpenshiftConfigFluent.RouteNested<A> editOrNewRoute() {
        return this.withNewRouteLike(this.getRoute() != null ? this.getRoute() : new RouteBuilder().build());
    }

    @Override
    public OpenshiftConfigFluent.RouteNested<A> editOrNewRouteLike(Route item) {
        return this.withNewRouteLike(this.getRoute() != null ? this.getRoute() : item);
    }

    @Override
    public Boolean getHeadless() {
        return this.headless;
    }

    @Override
    public A withHeadless(Boolean headless) {
        this.headless = headless;
        return (A)this;
    }

    @Override
    public Boolean hasHeadless() {
        return this.headless != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenshiftConfigFluentImpl that = (OpenshiftConfigFluentImpl)o;
        if (this.initContainers != null ? !this.initContainers.equals(that.initContainers) : that.initContainers != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.route != null ? !this.route.equals(that.route) : that.route != null) {
            return false;
        }
        return !(this.headless != null ? !this.headless.equals(that.headless) : that.headless != null);
    }

    public int hashCode() {
        return Objects.hash(this.initContainers, this.replicas, this.route, this.headless, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.initContainers != null && !this.initContainers.isEmpty()) {
            sb.append("initContainers:");
            sb.append(this.initContainers + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.route != null) {
            sb.append("route:");
            sb.append(this.route + ",");
        }
        if (this.headless != null) {
            sb.append("headless:");
            sb.append(this.headless);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withHeadless() {
        return this.withHeadless(true);
    }

    class RouteNestedImpl<N>
    extends RouteFluentImpl<OpenshiftConfigFluent.RouteNested<N>>
    implements OpenshiftConfigFluent.RouteNested<N>,
    Nested<N> {
        RouteBuilder builder;

        RouteNestedImpl(Route item) {
            this.builder = new RouteBuilder(this, item);
        }

        RouteNestedImpl() {
            this.builder = new RouteBuilder(this);
        }

        @Override
        public N and() {
            return (N)OpenshiftConfigFluentImpl.this.withRoute(this.builder.build());
        }

        @Override
        public N endRoute() {
            return this.and();
        }
    }

    class InitContainersNestedImpl<N>
    extends ContainerFluentImpl<OpenshiftConfigFluent.InitContainersNested<N>>
    implements OpenshiftConfigFluent.InitContainersNested<N>,
    Nested<N> {
        ContainerBuilder builder;
        Integer index;

        InitContainersNestedImpl(Integer index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder((ContainerFluent)this, item);
        }

        InitContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder((ContainerFluent)this);
        }

        @Override
        public N and() {
            return (N)OpenshiftConfigFluentImpl.this.setToInitContainers(this.index, (Container)this.builder.build());
        }

        @Override
        public N endInitContainer() {
            return this.and();
        }
    }
}

