/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ContainerFluent;

@Description(value="A decorator that applies the working directory to the application container.")
public class ApplyWorkingDirDecorator
extends ApplicationContainerDecorator<ContainerFluent<?>> {
    private final String workingDir;

    public ApplyWorkingDirDecorator(String containerName, String workingDir) {
        super(null, containerName);
        this.workingDir = workingDir;
    }

    @Override
    public void andThenVisit(ContainerFluent<?> container) {
        if (this.isApplicable(container) && Strings.isNotNullOrEmpty((String)this.workingDir)) {
            container.withWorkingDir(this.workingDir);
        }
    }
}

