/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.utils.Ports;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ServicePortFluent;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ApplyNodePortToServiceDecorator
extends NamedResourceDecorator<ServicePortFluent> {
    private final Optional<Port> port;

    public ApplyNodePortToServiceDecorator(BaseConfig config, Port[] ports, String defaultPort) {
        super(config.getName());
        this.port = this.findPort(ports, Ports.getPortByFilter(p -> p.getName().equals(defaultPort), (BaseConfig)config));
    }

    @Override
    public void andThenVisit(ServicePortFluent servicePort, ObjectMeta resourceMeta) {
        if (!this.port.isPresent()) {
            return;
        }
        if (this.port.get().getName().equals(servicePort.getName())) {
            if (this.hasNodePort(this.port.get())) {
                servicePort.withNodePort(this.port.get().getNodePort());
            } else {
                servicePort.withNodePort(Ports.calculateNodePort((String)this.getName(), (Port)this.port.get()));
            }
        }
    }

    private Optional<Port> findPort(Port[] ports, Optional<Port> defaultPort) {
        if (ports != null) {
            if (ports.length == 1) {
                return Optional.of(ports[0]);
            }
            List portsWithNodePort = Arrays.stream(ports).filter(this::hasNodePort).collect(Collectors.toList());
            if (portsWithNodePort.size() == 1) {
                return Optional.of(portsWithNodePort.get(0));
            }
        }
        return defaultPort;
    }

    private boolean hasNodePort(Port port) {
        return port.getNodePort() != null && port.getNodePort() > 0;
    }
}

