/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.adapter.ContainerAdapter;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import java.util.Collection;

@Description(value="Add an sidecar container to a pod template.")
public class AddSidecarDecorator
extends NamedResourceDecorator<PodSpecBuilder> {
    private final io.dekorate.kubernetes.config.Container container;

    public AddSidecarDecorator(io.dekorate.kubernetes.config.Container container) {
        this(ANY, container);
    }

    public AddSidecarDecorator(String deployment, io.dekorate.kubernetes.config.Container container) {
        super(deployment);
        this.container = container;
    }

    @Override
    public void andThenVisit(PodSpecBuilder podSpec, ObjectMeta resourceMeta) {
        Container resource = ContainerAdapter.adapt(this.container);
        if (podSpec.hasMatchingContainer(this::existsContainerByName)) {
            this.update(podSpec, resource);
        } else {
            this.add(podSpec, resource);
        }
    }

    private void add(PodSpecBuilder podSpec, Container resource) {
        podSpec.addToContainers(new Container[]{resource});
    }

    private void update(PodSpecBuilder podSpec, Container resource) {
        PodSpecFluent.ContainersNested matching = podSpec.editMatchingContainer(this::existsContainerByName);
        if (resource.getImage() != null) {
            matching.withImage(resource.getImage());
        }
        if (resource.getImagePullPolicy() != null) {
            matching.withImagePullPolicy(resource.getImagePullPolicy());
        }
        if (resource.getWorkingDir() != null) {
            matching.withWorkingDir(resource.getWorkingDir());
        }
        if (resource.getCommand() != null && !resource.getCommand().isEmpty()) {
            matching.withCommand(resource.getCommand());
        }
        if (resource.getArgs() != null && !resource.getArgs().isEmpty()) {
            matching.withArgs(resource.getArgs());
        }
        if (resource.getReadinessProbe() != null) {
            matching.withReadinessProbe(resource.getReadinessProbe());
        }
        if (resource.getLivenessProbe() != null) {
            matching.withLivenessProbe(resource.getLivenessProbe());
        }
        matching.addAllToEnv((Collection)resource.getEnv());
        if (resource.getPorts() != null && !resource.getPorts().isEmpty()) {
            matching.withPorts(resource.getPorts());
        }
        matching.endContainer();
    }

    private boolean existsContainerByName(ContainerBuilder containerBuilder) {
        return containerBuilder.getName().equals(this.container.getName());
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class};
    }
}

