/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.Item;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.KeyToPathBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Description(value="Add a secret volume to all pod specs.")
public class AddSecretVolumeDecorator
extends NamedResourceDecorator<PodSpecFluent<?>> {
    private final SecretVolume volume;

    public AddSecretVolumeDecorator(SecretVolume volume) {
        this(ANY, volume);
    }

    public AddSecretVolumeDecorator(String name, SecretVolume volume) {
        super(name);
        this.volume = volume;
    }

    @Override
    public void andThenVisit(PodSpecFluent<?> podSpec, ObjectMeta resourceMeta) {
        ((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)((VolumeFluent.SecretNested)((VolumeFluent.SecretNested)((VolumeFluent.SecretNested)((PodSpecFluent.VolumesNested)podSpec.addNewVolume().withName(this.volume.getVolumeName())).withNewSecret().withSecretName(this.volume.getSecretName())).withDefaultMode(this.volume.getDefaultMode())).withOptional(Boolean.valueOf(this.volume.isOptional()))).withItems(this.toKeyToPathList(this.volume.getItems()))).endSecret()).endVolume();
    }

    private List<KeyToPath> toKeyToPathList(Item[] items) {
        if (items == null || items.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<KeyToPath> keyToPathList = new ArrayList<KeyToPath>(items.length);
        for (Item item : items) {
            KeyToPathBuilder builder = (KeyToPathBuilder)((KeyToPathBuilder)new KeyToPathBuilder().withKey(item.getKey())).withPath(item.getPath());
            if (item.getMode() > 0) {
                builder.withMode(item.getMode());
            }
            keyToPathList.add(builder.build());
        }
        return keyToPathList;
    }
}

