/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;

public class AddDockerConfigJsonSecretDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    public static final String DOT_DOCKER_CONFIG_JSON = ".dockerconfigjson";
    private static final String TYPE = "kubernetes.io/dockerconfigjson";
    private static final String DOCKER_CONFIG_STR = "{\n \t\"auths\": {\n\t\t\"%s\": {\n \t\t\t\"auth\":\"%s\"\n\t\t}\n\t}\n}";
    private static final Charset CHARSET = Charset.defaultCharset();
    private final String name;
    private final String content;
    private final Map<String, String> annotations;

    public AddDockerConfigJsonSecretDecorator(String name, String registry, String username, String password) {
        this(name, registry, username, password, Collections.emptyMap());
    }

    public AddDockerConfigJsonSecretDecorator(String name, String registry, String username, String password, Map<String, String> annotations) {
        this.name = name;
        this.annotations = annotations;
        this.content = new String(Base64.getEncoder().encode(String.format(DOCKER_CONFIG_STR, registry, new String(Base64.getEncoder().encode((username + ":" + password).getBytes(CHARSET)), CHARSET)).getBytes(CHARSET)), CHARSET);
    }

    public AddDockerConfigJsonSecretDecorator(String name, Path existingConfigJson) {
        this(name, existingConfigJson, Collections.emptyMap());
    }

    public AddDockerConfigJsonSecretDecorator(String name, Path existingConfigJson, Map<String, String> annotations) {
        this.name = name;
        this.annotations = annotations;
        this.content = new String(Base64.getEncoder().encode(Strings.read((Path)existingConfigJson).getBytes(CHARSET)), CHARSET);
    }

    public void visit(KubernetesListBuilder list) {
        String name = Strings.isNotNullOrEmpty((String)this.name) ? this.name : this.getMandatoryDeploymentMetadata(list, ANY).getName();
        Secret secret = ((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(name)).withAnnotations(this.annotations)).endMetadata()).withType(TYPE)).addToData(DOT_DOCKER_CONFIG_JSON, this.content)).build();
        list.addToItems(new HasMetadata[]{secret});
    }
}

