/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.Item;
import io.dekorate.kubernetes.config.ItemBuilder;
import io.dekorate.kubernetes.config.ItemFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ConfigMapVolumeFluent<A extends ConfigMapVolumeFluent<A>>
extends BaseFluent<A> {
    private String volumeName;
    private String configMapName;
    private Integer defaultMode;
    private Boolean optional;
    private ArrayList<ItemBuilder> items = new ArrayList();

    public ConfigMapVolumeFluent() {
    }

    public ConfigMapVolumeFluent(ConfigMapVolume instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConfigMapVolume instance) {
        ConfigMapVolume configMapVolume = instance = instance != null ? instance : new ConfigMapVolume();
        if (instance != null) {
            this.withVolumeName(instance.getVolumeName());
            this.withConfigMapName(instance.getConfigMapName());
            this.withDefaultMode(instance.getDefaultMode());
            this.withOptional(instance.getOptional());
            this.withItems(instance.getItems());
        }
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)((Object)this);
    }

    public boolean hasVolumeName() {
        return this.volumeName != null;
    }

    public String getConfigMapName() {
        return this.configMapName;
    }

    public A withConfigMapName(String configMapName) {
        this.configMapName = configMapName;
        return (A)((Object)this);
    }

    public boolean hasConfigMapName() {
        return this.configMapName != null;
    }

    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public A withDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return (A)((Object)this);
    }

    public boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public A withOptional(Boolean optional) {
        this.optional = optional;
        return (A)((Object)this);
    }

    public boolean hasOptional() {
        return this.optional != null;
    }

    public A withItems(Item ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove((Object)"items");
        }
        if (items != null) {
            for (Item item : items) {
                this.addToItems(item);
            }
        }
        return (A)((Object)this);
    }

    public Item[] buildItems() {
        int size = this.items != null ? this.items.size() : 0;
        Item[] result = new Item[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.items) {
            result[index++] = (Item)visitableBuilder.build();
        }
        return result;
    }

    public Item buildItem(int index) {
        return this.items.get(index).build();
    }

    public Item buildFirstItem() {
        return this.items.get(0).build();
    }

    public Item buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    public Item buildMatchingItem(Predicate<ItemBuilder> predicate) {
        for (ItemBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingItem(Predicate<ItemBuilder> predicate) {
        for (ItemBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToItems(int index, Item item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ItemBuilder builder = new ItemBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").add(index, builder);
            this.items.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToItems(int index, Item item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ItemBuilder builder = new ItemBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
            this.items.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToItems(Item ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (Item item : items) {
            ItemBuilder builder = new ItemBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToItems(Collection<Item> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (Item item : items) {
            ItemBuilder builder = new ItemBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromItems(Item ... items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (Item item : items) {
            ItemBuilder builder = new ItemBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromItems(Collection<Item> items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (Item item : items) {
            ItemBuilder builder = new ItemBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromItems(Predicate<ItemBuilder> predicate) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        Iterator<ItemBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            ItemBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public A addNewItem(String key, String path, Integer mode) {
        return this.addToItems(new Item(key, path, mode));
    }

    public ItemsNested<A> addNewItem() {
        return new ItemsNested(-1, null);
    }

    public ItemsNested<A> addNewItemLike(Item item) {
        return new ItemsNested(-1, item);
    }

    public ItemsNested<A> setNewItemLike(int index, Item item) {
        return new ItemsNested(index, item);
    }

    public ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    public ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editMatchingItem(Predicate<ItemBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapVolumeFluent that = (ConfigMapVolumeFluent)((Object)o);
        if (!Objects.equals(this.volumeName, that.volumeName)) {
            return false;
        }
        if (!Objects.equals(this.configMapName, that.configMapName)) {
            return false;
        }
        if (!Objects.equals(this.defaultMode, that.defaultMode)) {
            return false;
        }
        if (!Objects.equals(this.optional, that.optional)) {
            return false;
        }
        return Objects.equals(this.items, that.items);
    }

    public int hashCode() {
        return Objects.hash(this.volumeName, this.configMapName, this.defaultMode, this.optional, this.items, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.volumeName != null) {
            sb.append("volumeName:");
            sb.append(this.volumeName + ",");
        }
        if (this.configMapName != null) {
            sb.append("configMapName:");
            sb.append(this.configMapName + ",");
        }
        if (this.defaultMode != null) {
            sb.append("defaultMode:");
            sb.append(this.defaultMode + ",");
        }
        if (this.optional != null) {
            sb.append("optional:");
            sb.append(this.optional + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withOptional() {
        return this.withOptional(true);
    }

    public class ItemsNested<N>
    extends ItemFluent<ItemsNested<N>>
    implements Nested<N> {
        ItemBuilder builder;
        int index;

        ItemsNested(int index, Item item) {
            this.index = index;
            this.builder = new ItemBuilder(this, item);
        }

        public N and() {
            return (N)ConfigMapVolumeFluent.this.setToItems(this.index, this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }
}

