/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.ConfigMapVolumeBuilder;
import io.dekorate.kubernetes.config.Item;
import java.util.Objects;

public class ConfigMapVolume {
    private String volumeName;
    private String configMapName;
    private Integer defaultMode;
    private Boolean optional;
    private Item[] items = new Item[0];

    public ConfigMapVolume() {
    }

    public ConfigMapVolume(String volumeName, String configMapName, Integer defaultMode, Boolean optional, Item[] items) {
        this.volumeName = volumeName;
        this.configMapName = configMapName;
        this.defaultMode = defaultMode;
        this.optional = optional;
        this.items = items != null ? items : new Item[]{};
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getConfigMapName() {
        return this.configMapName;
    }

    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public boolean isOptional() {
        return this.optional != null && this.optional != false;
    }

    public Item[] getItems() {
        return this.items;
    }

    public static ConfigMapVolumeBuilder newBuilder() {
        return new ConfigMapVolumeBuilder();
    }

    public static ConfigMapVolumeBuilder newBuilderFromDefaults() {
        return (ConfigMapVolumeBuilder)((Object)((ConfigMapVolumeBuilder)((Object)new ConfigMapVolumeBuilder().withDefaultMode(384))).withOptional(false));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapVolume that = (ConfigMapVolume)o;
        if (!Objects.equals(this.volumeName, that.volumeName)) {
            return false;
        }
        if (!Objects.equals(this.configMapName, that.configMapName)) {
            return false;
        }
        if (!Objects.equals(this.defaultMode, that.defaultMode)) {
            return false;
        }
        if (!Objects.equals(this.optional, that.optional)) {
            return false;
        }
        return Objects.equals(this.items, that.items);
    }

    public int hashCode() {
        return Objects.hash(this.volumeName, this.configMapName, this.defaultMode, this.optional, this.items, super.hashCode());
    }
}

