/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;

@Description(value="Add an Azure disk volume to the pod spec.")
public class AddAzureDiskVolumeDecorator
extends NamedResourceDecorator<PodSpecFluent<?>> {
    private final AzureDiskVolume volume;

    public AddAzureDiskVolumeDecorator(AzureDiskVolume volume) {
        this(ANY, volume);
    }

    public AddAzureDiskVolumeDecorator(String name, AzureDiskVolume volume) {
        super(name);
        this.volume = volume;
    }

    @Override
    public void andThenVisit(PodSpecFluent<?> podSpec, ObjectMeta resourceMeta) {
        ((PodSpecFluent.VolumesNested)((VolumeFluent.AzureDiskNested)((VolumeFluent.AzureDiskNested)((VolumeFluent.AzureDiskNested)((VolumeFluent.AzureDiskNested)((VolumeFluent.AzureDiskNested)((VolumeFluent.AzureDiskNested)((PodSpecFluent.VolumesNested)podSpec.addNewVolume().withName(this.volume.getVolumeName())).withNewAzureDisk().withKind(this.volume.getKind())).withDiskName(this.volume.getDiskName())).withDiskURI(this.volume.getDiskURI())).withFsType(this.volume.getFsType())).withCachingMode(this.volume.getCachingMode())).withReadOnly(Boolean.valueOf(this.volume.isReadOnly()))).endAzureDisk()).endVolume();
    }
}

