/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.Item;
import io.dekorate.kubernetes.config.SecretVolumeBuilder;
import java.util.Objects;

public class SecretVolume {
    private String volumeName;
    private String secretName;
    private Integer defaultMode;
    private Boolean optional;
    private Item[] items = new Item[0];

    public SecretVolume() {
    }

    public SecretVolume(String volumeName, String secretName, Integer defaultMode, Boolean optional, Item[] items) {
        this.volumeName = volumeName;
        this.secretName = secretName;
        this.defaultMode = defaultMode;
        this.optional = optional;
        this.items = items != null ? items : new Item[]{};
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public boolean isOptional() {
        return this.optional != null && this.optional != false;
    }

    public Item[] getItems() {
        return this.items;
    }

    public static SecretVolumeBuilder newBuilder() {
        return new SecretVolumeBuilder();
    }

    public static SecretVolumeBuilder newBuilderFromDefaults() {
        return (SecretVolumeBuilder)((SecretVolumeBuilder)new SecretVolumeBuilder().withDefaultMode(384)).withOptional(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretVolume that = (SecretVolume)o;
        if (this.volumeName != null ? !this.volumeName.equals(that.volumeName) : that.volumeName != null) {
            return false;
        }
        if (this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null) {
            return false;
        }
        if (this.defaultMode != null ? !this.defaultMode.equals(that.defaultMode) : that.defaultMode != null) {
            return false;
        }
        if (this.optional != null ? !this.optional.equals(that.optional) : that.optional != null) {
            return false;
        }
        return !(this.items != null ? !this.items.equals(that.items) : that.items != null);
    }

    public int hashCode() {
        return Objects.hash(this.volumeName, this.secretName, this.defaultMode, this.optional, this.items, super.hashCode());
    }
}

