/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.ImageConfigurationBuilder;
import io.dekorate.project.Project;
import io.dekorate.utils.Strings;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class ImageConfiguration
extends ApplicationConfiguration {
    private Boolean enabled;
    private String registry;
    private String group;
    private String name;
    private String version;
    private String image;
    private String dockerFile;
    private Boolean autoBuildEnabled;
    private Boolean autoPushEnabled;
    private Boolean autoLoadEnabled;

    public static ImageConfiguration from(ApplicationConfiguration applicationConfiguration) {
        return ((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)new ImageConfigurationBuilder().withEnabled(true)).withProject(applicationConfiguration.getProject())).withGroup(applicationConfiguration.getPartOf())).withPartOf(applicationConfiguration.getPartOf())).withName(applicationConfiguration.getName())).withVersion(applicationConfiguration.getVersion())).withAttributes(applicationConfiguration.getAttributes())).build();
    }

    public ImageConfiguration() {
    }

    public ImageConfiguration(Project project, Map<ConfigKey, Object> attributes, Boolean enabled, String registry, String group, String name, String version, String image, String dockerFile, Boolean autoBuildEnabled, Boolean autoPushEnabled, Boolean autoLoadEnabled) {
        super(project, attributes, group, name, version);
        this.enabled = enabled;
        this.registry = registry;
        this.group = Strings.isNotNullOrEmpty((String)group) ? group : System.getProperty("user.name");
        this.name = name;
        this.version = version;
        this.image = image;
        this.dockerFile = dockerFile;
        this.autoBuildEnabled = autoBuildEnabled;
        this.autoPushEnabled = autoPushEnabled;
        this.autoLoadEnabled = autoLoadEnabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getDockerFile() {
        return this.dockerFile;
    }

    public void setDockerFile(String dockerFile) {
        this.dockerFile = dockerFile;
    }

    public Boolean getAutoBuildEnabled() {
        return this.autoBuildEnabled;
    }

    public boolean isAutoBuildEnabled() {
        return this.autoBuildEnabled != null && this.autoBuildEnabled != false;
    }

    public void setAutoBuildEnabled(Boolean autoBuildEnabled) {
        this.autoBuildEnabled = autoBuildEnabled;
    }

    public Boolean getAutoPushEnabled() {
        return this.autoPushEnabled;
    }

    public boolean isAutoPushEnabled() {
        return this.autoPushEnabled != null && this.autoPushEnabled != false;
    }

    public void setAutoPushEnabled(Boolean autoPushEnabled) {
        this.autoPushEnabled = autoPushEnabled;
    }

    public boolean isAutoLoadEnabled() {
        return this.autoLoadEnabled != null && this.autoLoadEnabled != false;
    }

    public Boolean getAutoLoadEnabled() {
        return this.autoLoadEnabled;
    }

    public void setAutoLoadEnabled(Boolean autoLoadEnabled) {
        this.autoLoadEnabled = autoLoadEnabled;
    }
}

