/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.config;

import io.dekorate.knative.config.AutoScaling;
import io.dekorate.knative.config.AutoScalingFluent;
import io.dekorate.knative.config.AutoScalingFluentImpl;
import io.dekorate.knative.config.EditableAutoScaling;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class AutoScalingBuilder
extends AutoScalingFluentImpl<AutoScalingBuilder>
implements VisitableBuilder<AutoScaling, AutoScalingBuilder> {
    AutoScalingFluent<?> fluent;
    Boolean validationEnabled;

    public AutoScalingBuilder() {
        this(false);
    }

    public AutoScalingBuilder(Boolean validationEnabled) {
        this(new AutoScaling(), validationEnabled);
    }

    public AutoScalingBuilder(AutoScalingFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public AutoScalingBuilder(AutoScalingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AutoScaling(), validationEnabled);
    }

    public AutoScalingBuilder(AutoScalingFluent<?> fluent, AutoScaling instance) {
        this(fluent, instance, false);
    }

    public AutoScalingBuilder(AutoScalingFluent<?> fluent, AutoScaling instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAutoScalerClass(instance.getAutoScalerClass());
        fluent.withMetric(instance.getMetric());
        fluent.withTarget(instance.getTarget());
        fluent.withContainerConcurrency(instance.getContainerConcurrency());
        fluent.withTargetUtilizationPercentage(instance.getTargetUtilizationPercentage());
        this.validationEnabled = validationEnabled;
    }

    public AutoScalingBuilder(AutoScaling instance) {
        this(instance, (Boolean)false);
    }

    public AutoScalingBuilder(AutoScaling instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAutoScalerClass(instance.getAutoScalerClass());
        this.withMetric(instance.getMetric());
        this.withTarget(instance.getTarget());
        this.withContainerConcurrency(instance.getContainerConcurrency());
        this.withTargetUtilizationPercentage(instance.getTargetUtilizationPercentage());
        this.validationEnabled = validationEnabled;
    }

    public EditableAutoScaling build() {
        EditableAutoScaling buildable = new EditableAutoScaling(this.fluent.getAutoScalerClass(), this.fluent.getMetric(), this.fluent.getTarget(), this.fluent.getContainerConcurrency(), this.fluent.getTargetUtilizationPercentage());
        return buildable;
    }
}

