/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.EnumeratedValue;
import io.debezium.converters.spi.SerializerType;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.storage.ConverterConfig;

public class CloudEventsConverterConfig
extends ConverterConfig {
    public static final String CLOUDEVENTS_SERIALIZER_TYPE_CONFIG = "serializer.type";
    public static final String CLOUDEVENTS_SERIALIZER_TYPE_DEFAULT = "json";
    private static final String CLOUDEVENTS_SERIALIZER_TYPE_DOC = "Specify a serializer to serialize CloudEvents values";
    public static final String CLOUDEVENTS_DATA_SERIALIZER_TYPE_CONFIG = "data.serializer.type";
    public static final String CLOUDEVENTS_DATA_SERIALIZER_TYPE_DEFAULT = "json";
    private static final String CLOUDEVENTS_DATA_SERIALIZER_TYPE_DOC = "Specify a serializer to serialize the data field of CloudEvents values";
    public static final String CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_CONFIG = "schema.name.adjustment.mode";
    public static final String CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DEFAULT = "avro";
    private static final String CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DOC = "Specify how schema names should be adjusted for compatibility with the message converter used by the connector, including:'avro' replaces the characters that cannot be used in the Avro type name with underscore (default)'none' does not apply any adjustment";
    public static final String CLOUDEVENTS_METADATA_LOCATION_CONFIG = "metadata.location";
    public static final String CLOUDEVENTS_METADATA_LOCATION_DEFAULT = "value";
    private static final String CLOUDEVENTS_METADATA_LOCATION_DOC = "Specify from where to retrieve metadata";
    private static final ConfigDef CONFIG = ConverterConfig.newConfigDef();

    public static ConfigDef configDef() {
        return CONFIG;
    }

    public CloudEventsConverterConfig(Map<String, ?> props) {
        super(CONFIG, props);
    }

    public SerializerType cloudeventsSerializerType() {
        return SerializerType.withName(this.getString(CLOUDEVENTS_SERIALIZER_TYPE_CONFIG));
    }

    public SerializerType cloudeventsDataSerializerTypeConfig() {
        return SerializerType.withName(this.getString(CLOUDEVENTS_DATA_SERIALIZER_TYPE_CONFIG));
    }

    public CommonConnectorConfig.SchemaNameAdjustmentMode schemaNameAdjustmentMode() {
        return CommonConnectorConfig.SchemaNameAdjustmentMode.parse(this.getString(CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_CONFIG));
    }

    public MetadataLocation metadataLocation() {
        return MetadataLocation.parse(this.getString(CLOUDEVENTS_METADATA_LOCATION_CONFIG));
    }

    static {
        CONFIG.define(CLOUDEVENTS_SERIALIZER_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"json", ConfigDef.Importance.HIGH, CLOUDEVENTS_SERIALIZER_TYPE_DOC);
        CONFIG.define(CLOUDEVENTS_DATA_SERIALIZER_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"json", ConfigDef.Importance.HIGH, CLOUDEVENTS_DATA_SERIALIZER_TYPE_DOC);
        CONFIG.define(CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_CONFIG, ConfigDef.Type.STRING, (Object)CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DEFAULT, ConfigDef.Importance.LOW, CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DOC);
        CONFIG.define(CLOUDEVENTS_METADATA_LOCATION_CONFIG, ConfigDef.Type.STRING, (Object)CLOUDEVENTS_METADATA_LOCATION_DEFAULT, ConfigDef.Importance.HIGH, CLOUDEVENTS_METADATA_LOCATION_DOC);
    }

    public static enum MetadataLocation implements EnumeratedValue
    {
        VALUE("value"),
        HEADER("header");

        private final String value;

        private MetadataLocation(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static MetadataLocation parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (MetadataLocation option : MetadataLocation.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }
    }
}

