/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schema;

import io.debezium.relational.Column;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.util.BoundedConcurrentHashMap;

public class FieldNameSelector {
    public static FieldNamer<Column> defaultSelector(SchemaNameAdjuster fieldNameAdjuster) {
        return new FieldNameCache<Column>(new FieldNameSanitizer<Column>(Column::name, fieldNameAdjuster));
    }

    public static FieldNamer<String> defaultNonRelationalSelector(SchemaNameAdjuster fieldNameAdjuster) {
        return new FieldNameCache<String>(new FieldNameSanitizer<String>(x -> x, fieldNameAdjuster));
    }

    private static class FieldNameCache<T>
    implements FieldNamer<T> {
        private final BoundedConcurrentHashMap<T, String> fieldNames = new BoundedConcurrentHashMap(10000, 10, BoundedConcurrentHashMap.Eviction.LRU);
        private final FieldNamer<T> delegate;

        FieldNameCache(FieldNamer<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String fieldNameFor(T column) {
            return this.fieldNames.computeIfAbsent(column, this.delegate::fieldNameFor);
        }
    }

    private static class FieldNameSanitizer<T>
    implements FieldNamer<T> {
        private final FieldNamer<T> delegate;
        private final SchemaNameAdjuster fieldNameAdjuster;

        FieldNameSanitizer(FieldNamer<T> delegate, SchemaNameAdjuster fieldNameAdjuster) {
            this.delegate = delegate;
            this.fieldNameAdjuster = fieldNameAdjuster;
        }

        @Override
        public String fieldNameFor(T column) {
            String fieldName = this.delegate.fieldNameFor(column);
            return this.fieldNameAdjuster.adjust(fieldName);
        }
    }

    @FunctionalInterface
    public static interface FieldNamer<T> {
        public String fieldNameFor(T var1);
    }
}

