/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline;

import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.pipeline.spi.OffsetContext;
import org.apache.kafka.connect.data.Struct;

public abstract class CommonOffsetContext<T extends BaseSourceInfo>
implements OffsetContext {
    protected final T sourceInfo;

    public CommonOffsetContext(T sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    @Override
    public Struct getSourceInfo() {
        return ((AbstractSourceInfo)this.sourceInfo).struct();
    }

    @Override
    public void markSnapshotRecord(SnapshotRecord record) {
        ((BaseSourceInfo)this.sourceInfo).setSnapshot(record);
    }

    @Override
    public void postSnapshotCompletion() {
        ((BaseSourceInfo)this.sourceInfo).setSnapshot(SnapshotRecord.FALSE);
    }

    @Override
    public void incrementalSnapshotEvents() {
        ((BaseSourceInfo)this.sourceInfo).setSnapshot(SnapshotRecord.INCREMENTAL);
    }
}

