/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ReplicationConnection;
import io.debezium.connector.postgresql.spi.SlotState;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Clock;
import io.debezium.util.ElapsedTimeStrategy;
import java.sql.SQLException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PostgresTaskContext
extends CdcSourceTaskContext {
    protected static final Logger LOGGER = LoggerFactory.getLogger(PostgresTaskContext.class);
    private final PostgresConnectorConfig config;
    private final TopicSelector<TableId> topicSelector;
    private final PostgresSchema schema;
    private ElapsedTimeStrategy refreshXmin;
    private Long lastXmin;

    protected PostgresTaskContext(PostgresConnectorConfig config, PostgresSchema schema, TopicSelector<TableId> topicSelector) {
        super(config.getContextName(), config.getLogicalName(), Collections::emptySet);
        this.config = config;
        if (config.xminFetchInterval().toMillis() > 0L) {
            this.refreshXmin = ElapsedTimeStrategy.constant((Clock)Clock.SYSTEM, (long)config.xminFetchInterval().toMillis());
        }
        this.topicSelector = topicSelector;
        assert (schema != null);
        this.schema = schema;
    }

    protected TopicSelector<TableId> topicSelector() {
        return this.topicSelector;
    }

    protected PostgresSchema schema() {
        return this.schema;
    }

    protected PostgresConnectorConfig config() {
        return this.config;
    }

    protected void refreshSchema(PostgresConnection connection, boolean printReplicaIdentityInfo) throws SQLException {
        this.schema.refresh(connection, printReplicaIdentityInfo);
    }

    Long getSlotXmin(PostgresConnection connection) throws SQLException {
        if (this.config.xminFetchInterval().toMillis() <= 0L) {
            return null;
        }
        assert (this.refreshXmin != null);
        if (this.refreshXmin.hasElapsed()) {
            this.lastXmin = this.getCurrentSlotState(connection).slotCatalogXmin();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Fetched new xmin from slot of {}", (Object)this.lastXmin);
            }
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("reusing xmin value of {}", (Object)this.lastXmin);
        }
        return this.lastXmin;
    }

    private SlotState getCurrentSlotState(PostgresConnection connection) throws SQLException {
        return connection.getReplicationSlotState(this.config.slotName(), this.config.plugin().getPostgresPluginName());
    }

    protected ReplicationConnection createReplicationConnection(boolean exportSnapshot) throws SQLException {
        return ReplicationConnection.builder(this.config.jdbcConfig()).withSlot(this.config.slotName()).withPublication(this.config.publicationName()).withPlugin(this.config.plugin()).dropSlotOnClose(this.config.dropSlotOnStop()).streamParams(this.config.streamParams()).statusUpdateInterval(this.config.statusUpdateInterval()).withTypeRegistry(this.schema.getTypeRegistry()).exportSnapshotOnCreate(exportSnapshot).withSchema(this.schema).build();
    }

    protected PostgresConnection createConnection() {
        return new PostgresConnection(this.config.jdbcConfig());
    }

    PostgresConnectorConfig getConfig() {
        return this.config;
    }
}

