/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.android;

import android.content.Context;
import cucumber.runtime.io.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public final class AndroidResource
implements Resource {
    private final Context context;
    private final URI path;
    private final String pathInAssets;

    AndroidResource(Context context, URI path) {
        this.context = context;
        this.path = path;
        this.pathInAssets = path.getSchemeSpecificPart();
    }

    public URI getPath() {
        return this.path;
    }

    public InputStream getInputStream() throws IOException {
        return this.context.getAssets().open(this.pathInAssets, 0);
    }

    public String toString() {
        return "AndroidResource (" + this.pathInAssets + ")";
    }
}

