/*
 * Decompiled with CFR 0.152.
 */
package io.continual.resources;

import com.amazonaws.services.s3.AmazonS3;
import io.continual.resources.ResourceSource;
import io.continual.resources.sources.AwsS3UriLoader;
import io.continual.resources.sources.ClassResourceLoader;
import io.continual.resources.sources.FileLoader;
import io.continual.resources.sources.HttpLoader;
import io.continual.resources.sources.JvmClassLoaderResourceLoader;
import io.continual.resources.sources.JvmSystemResourceLoader;
import io.continual.util.data.TypeConvertor;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class ResourceLoader {
    private LinkedList<ResourceSource> fSources = new LinkedList();
    private String fNamed = null;
    private boolean fSrcSpecd = false;
    private static boolean sCheckedS3 = false;
    private static boolean sS3Available = false;
    private static boolean sS3Disabled = !TypeConvertor.convertToBooleanBroad((String)System.getenv("DRIFT_ALLOW_S3"));

    public static InputStream load(String resource) throws IOException {
        return new ResourceLoader().named(resource).load();
    }

    public ResourceLoader usingStandardSources() {
        return this.usingStandardSources(true);
    }

    public ResourceLoader usingStandardSources(boolean withNetwork) {
        return this.usingStandardSources(withNetwork, null);
    }

    public ResourceLoader usingStandardSources(boolean withNetwork, Class<?> referenceClass) {
        if (withNetwork) {
            if (ResourceLoader.s3Available()) {
                this.usingSource(new AwsS3UriLoader());
            }
            this.usingSource(new HttpLoader());
        }
        this.usingSource(new FileLoader());
        if (referenceClass != null) {
            this.usingSource(new ClassResourceLoader(referenceClass));
            this.usingSource(new JvmClassLoaderResourceLoader(referenceClass));
        }
        this.usingSource(new JvmSystemResourceLoader());
        return this;
    }

    public ResourceLoader usingSource(ResourceSource rs) {
        this.fSrcSpecd = true;
        this.fSources.add(rs);
        return this;
    }

    public ResourceLoader named(String name) {
        this.fNamed = name;
        return this;
    }

    public InputStream load() throws IOException {
        if (this.fNamed == null) {
            return null;
        }
        if (!this.fSrcSpecd) {
            this.usingStandardSources();
        }
        for (ResourceSource src : this.fSources) {
            InputStream result;
            if (!src.qualifies(this.fNamed) || (result = src.loadResource(this.fNamed)) == null) continue;
            return result;
        }
        return null;
    }

    public String toString() {
        return this.fNamed;
    }

    public static boolean s3Available() {
        if (!sCheckedS3 && !sS3Disabled) {
            sCheckedS3 = true;
            try {
                Class<AmazonS3> clazz = AmazonS3.class;
                sS3Available = clazz != null;
            }
            catch (NoClassDefFoundError x) {
                sS3Available = false;
            }
        }
        return sS3Available;
    }
}

