/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCallActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.CallActivity;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeBindingType;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeCalledElement;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collections;
import java.util.List;
import org.agrona.DirectBuffer;

public final class CallActivityTransformer
implements ModelElementTransformer<CallActivity> {
    @Override
    public Class<CallActivity> getType() {
        return CallActivity.class;
    }

    @Override
    public void transform(CallActivity element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableCallActivity callActivity = process.getElementById(element.getId(), ExecutableCallActivity.class);
        this.transformCalledElement(element, callActivity, context.getExpressionLanguage());
        CallActivityTransformer.transformLexicographicIndex(element, context.getProcesses(), callActivity);
    }

    private void transformCalledElement(CallActivity element, ExecutableCallActivity callActivity, ExpressionLanguage expressionLanguage) {
        ZeebeCalledElement calledElement = (ZeebeCalledElement)element.getSingleExtensionElement(ZeebeCalledElement.class);
        String processId = calledElement.getProcessId();
        Expression expression = expressionLanguage.parseExpression(processId);
        callActivity.setCalledElementProcessId(expression);
        boolean propagateAllChildVariablesEnabled = calledElement.isPropagateAllChildVariablesEnabled();
        callActivity.setPropagateAllChildVariablesEnabled(propagateAllChildVariablesEnabled);
        boolean propagateAllParentVariablesEnabled = calledElement.isPropagateAllParentVariablesEnabled();
        callActivity.setPropagateAllParentVariablesEnabled(propagateAllParentVariablesEnabled);
        ZeebeBindingType bindingType = calledElement.getBindingType();
        callActivity.setBindingType(bindingType);
        String versionTag = calledElement.getVersionTag();
        callActivity.setVersionTag(versionTag);
    }

    private static void transformLexicographicIndex(CallActivity element, List<ExecutableProcess> processes, ExecutableCallActivity callActivity) {
        List<String> allCallActivityIds = processes.stream().flatMap(p -> p.getFlowElements().stream()).filter(ExecutableCallActivity.class::isInstance).map(ca -> BufferUtil.bufferAsString((DirectBuffer)ca.getId())).sorted().toList();
        int index = Collections.binarySearch(allCallActivityIds, element.getId());
        callActivity.setLexicographicIndex(index);
    }
}

