/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.element;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutionListener;
import io.camunda.zeebe.engine.processing.deployment.model.element.JobWorkerProperties;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListenerEventType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ExecutableFlowNode
extends AbstractFlowElement {
    private final List<ExecutableSequenceFlow> incoming = new ArrayList<ExecutableSequenceFlow>();
    private final List<ExecutableSequenceFlow> outgoing = new ArrayList<ExecutableSequenceFlow>();
    private Optional<Expression> inputMappings = Optional.empty();
    private Optional<Expression> outputMappings = Optional.empty();
    private final List<ExecutionListener> executionListeners = new ArrayList<ExecutionListener>();

    public ExecutableFlowNode(String id) {
        super(id);
    }

    public List<ExecutableSequenceFlow> getOutgoing() {
        return this.outgoing;
    }

    public void addOutgoing(ExecutableSequenceFlow flow) {
        this.outgoing.add(flow);
    }

    public List<ExecutableSequenceFlow> getIncoming() {
        return this.incoming;
    }

    public void addIncoming(ExecutableSequenceFlow flow) {
        this.incoming.add(flow);
    }

    public Optional<Expression> getInputMappings() {
        return this.inputMappings;
    }

    public void setInputMappings(Expression inputMappings) {
        this.inputMappings = Optional.of(inputMappings);
    }

    public Optional<Expression> getOutputMappings() {
        return this.outputMappings;
    }

    public void setOutputMappings(Expression outputMappings) {
        this.outputMappings = Optional.of(outputMappings);
    }

    public void addListener(ZeebeExecutionListenerEventType eventType, Expression type, Expression retries) {
        ExecutionListener listener = new ExecutionListener();
        listener.setEventType(eventType);
        JobWorkerProperties jobWorkerProperties = new JobWorkerProperties();
        jobWorkerProperties.setType(type);
        jobWorkerProperties.setRetries(retries);
        listener.setJobWorkerProperties(jobWorkerProperties);
        this.executionListeners.add(listener);
    }

    public List<ExecutionListener> getStartExecutionListeners() {
        return this.executionListeners.stream().filter(el -> el.getEventType() == ZeebeExecutionListenerEventType.start).toList();
    }

    public List<ExecutionListener> getEndExecutionListeners() {
        return this.executionListeners.stream().filter(el -> el.getEventType() == ZeebeExecutionListenerEventType.end).toList();
    }

    public boolean hasExecutionListeners() {
        return !this.executionListeners.isEmpty();
    }
}

