/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.common;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCallActivity;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class ElementTreePathBuilder {
    private ElementInstanceState elementInstanceState;
    private ProcessState processState;
    private Long elementInstanceKey;
    private ElementTreePathProperties properties;

    public ElementTreePathBuilder withElementInstanceState(ElementInstanceState elementInstanceState) {
        this.elementInstanceState = elementInstanceState;
        return this;
    }

    public ElementTreePathBuilder withProcessState(ProcessState processState) {
        this.processState = processState;
        return this;
    }

    public ElementTreePathBuilder withElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
        return this;
    }

    public ElementTreePathProperties build() {
        Objects.requireNonNull(this.elementInstanceState, "elementInstanceState cannot be null");
        Objects.requireNonNull(this.processState, "processState cannot be null");
        Objects.requireNonNull(this.elementInstanceKey, "elementInstanceKey cannot be null");
        this.properties = new ElementTreePathProperties(new LinkedList<List<Long>>(), new LinkedList<Long>(), new LinkedList<Integer>());
        this.buildElementTreePathProperties(this.elementInstanceKey);
        return this.properties;
    }

    private void buildElementTreePathProperties(long elementInstanceKey) {
        LinkedList<Long> elementInstancePath = new LinkedList<Long>();
        elementInstancePath.add(elementInstanceKey);
        ElementInstance instance = this.elementInstanceState.getInstance(elementInstanceKey);
        long parentElementInstanceKey = instance.getParentKey();
        while (parentElementInstanceKey != -1L) {
            instance = this.elementInstanceState.getInstance(parentElementInstanceKey);
            elementInstancePath.addFirst(parentElementInstanceKey);
            parentElementInstanceKey = instance.getParentKey();
        }
        this.properties.elementInstancePath.addFirst(elementInstancePath);
        ProcessInstanceRecord processInstanceRecord = instance.getValue();
        this.properties.processDefinitionPath.addFirst(processInstanceRecord.getProcessDefinitionKey());
        long callingElementInstanceKey = processInstanceRecord.getParentElementInstanceKey();
        if (callingElementInstanceKey != -1L) {
            this.properties.callingElementPath.addFirst(this.getCallActivityIndex(callingElementInstanceKey));
            this.buildElementTreePathProperties(callingElementInstanceKey);
        }
    }

    private Integer getCallActivityIndex(long callingElementInstanceKey) {
        ElementInstance callActivityElementInstance = this.elementInstanceState.getInstance(callingElementInstanceKey);
        ProcessInstanceRecord callActivityInstanceRecord = callActivityElementInstance.getValue();
        ExecutableCallActivity callActivity = this.processState.getFlowElement(callActivityInstanceRecord.getProcessDefinitionKey(), callActivityInstanceRecord.getTenantId(), callActivityInstanceRecord.getElementIdBuffer(), ExecutableCallActivity.class);
        return callActivity.getLexicographicIndex();
    }

    public record ElementTreePathProperties(List<List<Long>> elementInstancePath, List<Long> processDefinitionPath, List<Integer> callingElementPath) {
    }
}

