/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.dmn.DecisionEvaluationResult;
import io.camunda.zeebe.dmn.ParsedDecisionRequirementsGraph;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.common.DecisionBehavior;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCalledDecision;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeBindingType;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.protocol.impl.record.value.decision.DecisionEvaluationRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.collection.Tuple;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;

public final class BpmnDecisionBehavior {
    private final DecisionBehavior decisionBehavior;
    private final EventTriggerBehavior eventTriggerBehavior;
    private final VariableState variableState;
    private final StateWriter stateWriter;
    private final KeyGenerator keyGenerator;
    private final ExpressionProcessor expressionBehavior;
    private final BpmnStateBehavior stateBehavior;

    public BpmnDecisionBehavior(DecisionBehavior decisionBehavior, ProcessingState processingState, EventTriggerBehavior eventTriggerBehavior, StateWriter stateWriter, KeyGenerator keyGenerator, ExpressionProcessor expressionBehavior, BpmnStateBehavior stateBehavior) {
        this.variableState = processingState.getVariableState();
        this.decisionBehavior = decisionBehavior;
        this.eventTriggerBehavior = eventTriggerBehavior;
        this.stateWriter = stateWriter;
        this.keyGenerator = keyGenerator;
        this.expressionBehavior = expressionBehavior;
        this.stateBehavior = stateBehavior;
    }

    public Either<Failure, DecisionEvaluationResult> evaluateDecision(ExecutableCalledDecision element, BpmnElementContext context) {
        long scopeKey = context.getElementInstanceKey();
        Either<Failure, String> decisionIdOrFailure = this.evalDecisionIdExpression(element, scopeKey);
        if (decisionIdOrFailure.isLeft()) {
            return Either.left((Object)((Failure)decisionIdOrFailure.getLeft()));
        }
        String decisionId = (String)decisionIdOrFailure.get();
        Either<Failure, PersistedDecision> decisionOrFailure = this.findCalledDecision(decisionId, element.getBindingType(), element.getVersionTag(), context);
        Either drgOrFailure = decisionOrFailure.flatMap(this.decisionBehavior::findParsedDrgByDecision).mapLeft(failure -> new Failure(failure.getMessage(), ErrorType.CALLED_DECISION_ERROR, scopeKey));
        DirectBuffer variables = this.variableState.getVariablesAsDocument(scopeKey);
        Either resultOrFailure = drgOrFailure.flatMap(drg -> {
            PersistedDecision decision = (PersistedDecision)((Object)((Object)decisionOrFailure.get()));
            DecisionEvaluationResult evaluationResult = this.decisionBehavior.evaluateDecisionInDrg((ParsedDecisionRequirementsGraph)drg, decisionId, variables);
            Tuple<DecisionEvaluationIntent, DecisionEvaluationRecord> eventTuple = this.decisionBehavior.createDecisionEvaluationEvent(decision, evaluationResult);
            this.writeDecisionEvaluationEvent(eventTuple, context);
            if (evaluationResult.isFailure()) {
                return Either.left((Object)new Failure(evaluationResult.getFailureMessage(), ErrorType.DECISION_EVALUATION_ERROR, scopeKey));
            }
            return Either.right((Object)evaluationResult);
        });
        resultOrFailure.ifRight(result -> this.triggerProcessEventWithResultVariable(context, element.getResultVariable(), (DecisionEvaluationResult)result));
        return resultOrFailure;
    }

    private Either<Failure, PersistedDecision> findCalledDecision(String decisionId, ZeebeBindingType bindingType, String versionTag, BpmnElementContext context) {
        return switch (bindingType) {
            default -> throw new MatchException(null, null);
            case ZeebeBindingType.deployment -> this.getDecisionVersionInSameDeployment(decisionId, context);
            case ZeebeBindingType.latest -> this.getLatestDecisionVersion(decisionId, context.getTenantId());
            case ZeebeBindingType.versionTag -> this.getLatestDecisionVersionWithVersionTag(decisionId, versionTag, context.getTenantId());
        };
    }

    private Either<Failure, PersistedDecision> getDecisionVersionInSameDeployment(String decisionId, BpmnElementContext context) {
        return this.stateBehavior.getDeploymentKey(context.getProcessDefinitionKey(), context.getTenantId()).flatMap(deploymentKey -> this.decisionBehavior.findDecisionByIdAndDeploymentKeyAndTenant(decisionId, (long)deploymentKey, context.getTenantId()));
    }

    private Either<Failure, PersistedDecision> getLatestDecisionVersion(String decisionId, String tenantId) {
        return this.decisionBehavior.findLatestDecisionByIdAndTenant(decisionId, tenantId);
    }

    private Either<Failure, PersistedDecision> getLatestDecisionVersionWithVersionTag(String decisionId, String versionTag, String tenantId) {
        return this.decisionBehavior.findDecisionByIdAndVersionTagAndTenant(decisionId, versionTag, tenantId);
    }

    private Either<Failure, String> evalDecisionIdExpression(ExecutableCalledDecision element, long scopeKey) {
        return this.expressionBehavior.evaluateStringExpression(element.getDecisionId(), scopeKey);
    }

    private void writeDecisionEvaluationEvent(Tuple<DecisionEvaluationIntent, DecisionEvaluationRecord> decisionEvaluationEventTuple, BpmnElementContext context) {
        DecisionEvaluationRecord evaluationEvent = (DecisionEvaluationRecord)decisionEvaluationEventTuple.getRight();
        evaluationEvent.setProcessDefinitionKey(context.getProcessDefinitionKey()).setBpmnProcessId(context.getBpmnProcessId()).setProcessInstanceKey(context.getProcessInstanceKey()).setElementInstanceKey(context.getElementInstanceKey()).setElementId(context.getElementId());
        long newDecisionEvaluationKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(newDecisionEvaluationKey, (Intent)decisionEvaluationEventTuple.getLeft(), (RecordValue)decisionEvaluationEventTuple.getRight());
    }

    private void triggerProcessEventWithResultVariable(BpmnElementContext context, String resultVariableName, DecisionEvaluationResult result) {
        DirectBuffer resultVariable = BpmnDecisionBehavior.serializeToNamedVariable(resultVariableName, result.getOutput());
        this.eventTriggerBehavior.triggeringProcessEvent(context.getProcessDefinitionKey(), context.getProcessInstanceKey(), context.getTenantId(), context.getElementInstanceKey(), context.getElementId(), resultVariable);
    }

    private static DirectBuffer serializeToNamedVariable(String name, DirectBuffer value) {
        ExpandableArrayBuffer resultBuffer = new ExpandableArrayBuffer();
        MsgPackWriter writer = new MsgPackWriter();
        writer.wrap((MutableDirectBuffer)resultBuffer, 0);
        writer.writeMapHeader(1);
        writer.writeString(BufferUtil.wrapString((String)name));
        writer.writeRaw(value);
        return resultBuffer;
    }
}

