/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing;

import io.camunda.zeebe.dmn.DecisionEngineFactory;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.processing.BpmnProcessors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviorsImpl;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobActivationBehavior;
import io.camunda.zeebe.engine.processing.clock.ClockProcessors;
import io.camunda.zeebe.engine.processing.common.DecisionBehavior;
import io.camunda.zeebe.engine.processing.deployment.DeploymentCreateProcessor;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributeProcessor;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributionCommandSender;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributionCompleteProcessor;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentRedistributor;
import io.camunda.zeebe.engine.processing.distribution.CommandDistributionAcknowledgeProcessor;
import io.camunda.zeebe.engine.processing.distribution.CommandDistributionBehavior;
import io.camunda.zeebe.engine.processing.distribution.CommandDistributionContinueProcessor;
import io.camunda.zeebe.engine.processing.distribution.CommandDistributionFinishProcessor;
import io.camunda.zeebe.engine.processing.distribution.CommandRedistributor;
import io.camunda.zeebe.engine.processing.dmn.DecisionEvaluationEvaluteProcessor;
import io.camunda.zeebe.engine.processing.identity.AuthorizationProcessors;
import io.camunda.zeebe.engine.processing.incident.IncidentEventProcessors;
import io.camunda.zeebe.engine.processing.job.JobEventProcessors;
import io.camunda.zeebe.engine.processing.message.MessageEventProcessors;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.resource.ResourceDeletionDeleteProcessor;
import io.camunda.zeebe.engine.processing.signal.SignalBroadcastProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.JobStreamer;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorContext;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.camunda.zeebe.engine.processing.user.UserProcessors;
import io.camunda.zeebe.engine.processing.usertask.UserTaskEventProcessors;
import io.camunda.zeebe.engine.state.immutable.DistributionState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.ScheduledTaskState;
import io.camunda.zeebe.engine.state.message.TransientPendingSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.routing.RoutingInfo;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.CommandDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ResourceDeletionIntent;
import io.camunda.zeebe.protocol.record.intent.SignalIntent;
import io.camunda.zeebe.stream.api.InterPartitionCommandSender;
import io.camunda.zeebe.stream.api.StreamClock;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.FeatureFlags;
import java.time.InstantSource;
import java.util.function.Supplier;

public final class EngineProcessors {
    private EngineProcessors() {
    }

    public static TypedRecordProcessors createEngineProcessors(TypedRecordProcessorContext typedRecordProcessorContext, int partitionsCount, SubscriptionCommandSender subscriptionCommandSender, InterPartitionCommandSender interPartitionCommandSender, FeatureFlags featureFlags, JobStreamer jobStreamer) {
        MutableProcessingState processingState = typedRecordProcessorContext.getProcessingState();
        KeyGenerator keyGenerator = processingState.getKeyGenerator();
        RoutingInfo routingInfo = RoutingInfo.dynamic(processingState.getRoutingState(), RoutingInfo.forStaticPartitions(partitionsCount));
        Supplier<ScheduledTaskState> scheduledTaskStateFactory = typedRecordProcessorContext.getScheduledTaskStateFactory();
        Writers writers = typedRecordProcessorContext.getWriters();
        TypedRecordProcessors typedRecordProcessors = TypedRecordProcessors.processors(keyGenerator, writers);
        typedRecordProcessors.withListener(processingState);
        StreamClock.ControllableStreamClock clock = typedRecordProcessorContext.getClock();
        int partitionId = typedRecordProcessorContext.getPartitionId();
        EngineConfiguration config = typedRecordProcessorContext.getConfig();
        DueDateTimerChecker timerChecker = new DueDateTimerChecker(scheduledTaskStateFactory.get().getTimerState(), featureFlags, (InstantSource)clock);
        JobMetrics jobMetrics = new JobMetrics(partitionId);
        ProcessEngineMetrics processEngineMetrics = new ProcessEngineMetrics(typedRecordProcessorContext.getMeterRegistry());
        subscriptionCommandSender.setWriters(writers);
        DecisionBehavior decisionBehavior = new DecisionBehavior(DecisionEngineFactory.createDecisionEngine(), processingState, processEngineMetrics);
        TransientPendingSubscriptionState transientProcessMessageSubscriptionState = typedRecordProcessorContext.getTransientProcessMessageSubscriptionState();
        BpmnBehaviorsImpl bpmnBehaviors = EngineProcessors.createBehaviors(processingState, writers, subscriptionCommandSender, routingInfo, timerChecker, jobStreamer, jobMetrics, decisionBehavior, (InstantSource)clock, transientProcessMessageSubscriptionState);
        CommandDistributionBehavior commandDistributionBehavior = new CommandDistributionBehavior(processingState.getDistributionState(), writers, typedRecordProcessorContext.getPartitionId(), routingInfo, interPartitionCommandSender);
        DeploymentDistributionCommandSender deploymentDistributionCommandSender = new DeploymentDistributionCommandSender(typedRecordProcessorContext.getPartitionId(), interPartitionCommandSender);
        EngineProcessors.addDeploymentRelatedProcessorAndServices(bpmnBehaviors, processingState, scheduledTaskStateFactory, typedRecordProcessors, writers, deploymentDistributionCommandSender, keyGenerator, featureFlags, commandDistributionBehavior, config, (InstantSource)clock);
        EngineProcessors.addMessageProcessors(bpmnBehaviors, subscriptionCommandSender, processingState, scheduledTaskStateFactory, typedRecordProcessors, writers, config, featureFlags, commandDistributionBehavior, (InstantSource)clock);
        TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor = EngineProcessors.addProcessProcessors(processingState, scheduledTaskStateFactory, bpmnBehaviors, typedRecordProcessors, subscriptionCommandSender, writers, timerChecker, commandDistributionBehavior, partitionId, routingInfo, (InstantSource)clock, transientProcessMessageSubscriptionState, processEngineMetrics);
        EngineProcessors.addDecisionProcessors(typedRecordProcessors, decisionBehavior, writers, processingState);
        JobEventProcessors.addJobProcessors(typedRecordProcessors, processingState, scheduledTaskStateFactory, bpmnBehaviors, writers, jobMetrics, config, (InstantSource)clock);
        EngineProcessors.addIncidentProcessors(processingState, bpmnStreamProcessor, typedRecordProcessors, writers, bpmnBehaviors.jobActivationBehavior());
        EngineProcessors.addResourceDeletionProcessors(typedRecordProcessors, writers, processingState, commandDistributionBehavior, bpmnBehaviors);
        EngineProcessors.addSignalBroadcastProcessors(typedRecordProcessors, bpmnBehaviors, writers, processingState, commandDistributionBehavior);
        EngineProcessors.addCommandDistributionProcessors(commandDistributionBehavior, typedRecordProcessors, writers, processingState, scheduledTaskStateFactory, interPartitionCommandSender);
        UserTaskEventProcessors.addUserTaskProcessors(typedRecordProcessors, processingState, bpmnBehaviors, writers);
        UserProcessors.addUserProcessors(keyGenerator, typedRecordProcessors, processingState, writers, commandDistributionBehavior, config);
        ClockProcessors.addClockProcessors(typedRecordProcessors, writers, keyGenerator, clock, commandDistributionBehavior);
        AuthorizationProcessors.addAuthorizationProcessors(keyGenerator, typedRecordProcessors, processingState, writers, commandDistributionBehavior);
        return typedRecordProcessors;
    }

    private static BpmnBehaviorsImpl createBehaviors(MutableProcessingState processingState, Writers writers, SubscriptionCommandSender subscriptionCommandSender, RoutingInfo routingInfo, DueDateTimerChecker timerChecker, JobStreamer jobStreamer, JobMetrics jobMetrics, DecisionBehavior decisionBehavior, InstantSource clock, TransientPendingSubscriptionState transientProcessMessageSubscriptionState) {
        return new BpmnBehaviorsImpl(processingState, writers, jobMetrics, decisionBehavior, subscriptionCommandSender, routingInfo, timerChecker, jobStreamer, clock, transientProcessMessageSubscriptionState);
    }

    private static TypedRecordProcessor<ProcessInstanceRecord> addProcessProcessors(MutableProcessingState processingState, Supplier<ScheduledTaskState> scheduledTaskState, BpmnBehaviorsImpl bpmnBehaviors, TypedRecordProcessors typedRecordProcessors, SubscriptionCommandSender subscriptionCommandSender, Writers writers, DueDateTimerChecker timerChecker, CommandDistributionBehavior commandDistributionBehavior, int partitionId, RoutingInfo routingInfo, InstantSource clock, TransientPendingSubscriptionState transientProcessMessageSubscriptionState, ProcessEngineMetrics processEngineMetrics) {
        return BpmnProcessors.addBpmnStreamProcessor(processingState, scheduledTaskState, bpmnBehaviors, typedRecordProcessors, subscriptionCommandSender, timerChecker, writers, commandDistributionBehavior, partitionId, routingInfo, clock, transientProcessMessageSubscriptionState, processEngineMetrics);
    }

    private static void addDeploymentRelatedProcessorAndServices(BpmnBehaviorsImpl bpmnBehaviors, ProcessingState processingState, Supplier<ScheduledTaskState> scheduledTaskStateSupplier, TypedRecordProcessors typedRecordProcessors, Writers writers, DeploymentDistributionCommandSender deploymentDistributionCommandSender, KeyGenerator keyGenerator, FeatureFlags featureFlags, CommandDistributionBehavior distributionBehavior, EngineConfiguration config, InstantSource clock) {
        DeploymentCreateProcessor processor = new DeploymentCreateProcessor(processingState, bpmnBehaviors, writers, keyGenerator, featureFlags, distributionBehavior, config, clock);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE, processor);
        DeploymentRedistributor deploymentRedistributor = new DeploymentRedistributor(deploymentDistributionCommandSender, scheduledTaskStateSupplier.get().getDeploymentState());
        typedRecordProcessors.withListener(deploymentRedistributor);
        DeploymentDistributeProcessor deploymentDistributeProcessor = new DeploymentDistributeProcessor(processingState, deploymentDistributionCommandSender, writers, keyGenerator);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.DISTRIBUTE, deploymentDistributeProcessor);
        DeploymentDistributionCompleteProcessor completeDeploymentDistributionProcessor = new DeploymentDistributionCompleteProcessor(processingState.getDeploymentState(), writers);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT_DISTRIBUTION, (Intent)DeploymentDistributionIntent.COMPLETE, completeDeploymentDistributionProcessor);
    }

    private static void addIncidentProcessors(ProcessingState processingState, TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor, TypedRecordProcessors typedRecordProcessors, Writers writers, BpmnJobActivationBehavior jobActivationBehavior) {
        IncidentEventProcessors.addProcessors(typedRecordProcessors, processingState, bpmnStreamProcessor, writers, jobActivationBehavior);
    }

    private static void addMessageProcessors(BpmnBehaviorsImpl bpmnBehaviors, SubscriptionCommandSender subscriptionCommandSender, MutableProcessingState processingState, Supplier<ScheduledTaskState> scheduledTaskStateFactory, TypedRecordProcessors typedRecordProcessors, Writers writers, EngineConfiguration config, FeatureFlags featureFlags, CommandDistributionBehavior commandDistributionBehavior, InstantSource clock) {
        MessageEventProcessors.addMessageProcessors(bpmnBehaviors, typedRecordProcessors, processingState, scheduledTaskStateFactory, subscriptionCommandSender, writers, config, featureFlags, commandDistributionBehavior, clock);
    }

    private static void addDecisionProcessors(TypedRecordProcessors typedRecordProcessors, DecisionBehavior decisionBehavior, Writers writers, MutableProcessingState processingState) {
        DecisionEvaluationEvaluteProcessor decisionEvaluationEvaluteProcessor = new DecisionEvaluationEvaluteProcessor(decisionBehavior, processingState.getKeyGenerator(), writers);
        typedRecordProcessors.onCommand(ValueType.DECISION_EVALUATION, (Intent)DecisionEvaluationIntent.EVALUATE, decisionEvaluationEvaluteProcessor);
    }

    private static void addResourceDeletionProcessors(TypedRecordProcessors typedRecordProcessors, Writers writers, MutableProcessingState processingState, CommandDistributionBehavior commandDistributionBehavior, BpmnBehaviors bpmnBehaviors) {
        ResourceDeletionDeleteProcessor resourceDeletionProcessor = new ResourceDeletionDeleteProcessor(writers, processingState.getKeyGenerator(), processingState, commandDistributionBehavior, bpmnBehaviors);
        typedRecordProcessors.onCommand(ValueType.RESOURCE_DELETION, (Intent)ResourceDeletionIntent.DELETE, resourceDeletionProcessor);
    }

    private static void addSignalBroadcastProcessors(TypedRecordProcessors typedRecordProcessors, BpmnBehaviorsImpl bpmnBehaviors, Writers writers, MutableProcessingState processingState, CommandDistributionBehavior commandDistributionBehavior) {
        SignalBroadcastProcessor signalBroadcastProcessor = new SignalBroadcastProcessor(writers, processingState.getKeyGenerator(), processingState, bpmnBehaviors.stateBehavior(), bpmnBehaviors.eventTriggerBehavior(), commandDistributionBehavior);
        typedRecordProcessors.onCommand(ValueType.SIGNAL, (Intent)SignalIntent.BROADCAST, signalBroadcastProcessor);
    }

    private static void addCommandDistributionProcessors(CommandDistributionBehavior commandDistributionBehavior, TypedRecordProcessors typedRecordProcessors, Writers writers, ProcessingState processingState, Supplier<ScheduledTaskState> scheduledTaskStateFactory, InterPartitionCommandSender interPartitionCommandSender) {
        typedRecordProcessors.withListener(new CommandRedistributor(scheduledTaskStateFactory.get().getDistributionState(), interPartitionCommandSender));
        DistributionState distributionState = processingState.getDistributionState();
        typedRecordProcessors.onCommand(ValueType.COMMAND_DISTRIBUTION, (Intent)CommandDistributionIntent.ACKNOWLEDGE, new CommandDistributionAcknowledgeProcessor(commandDistributionBehavior, distributionState, writers));
        typedRecordProcessors.onCommand(ValueType.COMMAND_DISTRIBUTION, (Intent)CommandDistributionIntent.FINISH, new CommandDistributionFinishProcessor(writers, commandDistributionBehavior));
        typedRecordProcessors.onCommand(ValueType.COMMAND_DISTRIBUTION, (Intent)CommandDistributionIntent.CONTINUE, new CommandDistributionContinueProcessor(distributionState, writers));
    }
}

