/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.transform;

import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.BpmnFactory;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.BpmnTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.validation.StraightThroughProcessingLoopValidator;
import io.camunda.zeebe.engine.processing.deployment.model.validation.UnsupportedMultiTenantFeaturesValidator;
import io.camunda.zeebe.engine.processing.deployment.transform.BpmnValidator;
import io.camunda.zeebe.engine.processing.deployment.transform.DeploymentResourceTransformer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeVersionTag;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.InputStream;
import java.time.InstantSource;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.io.DirectBufferInputStream;
import org.camunda.bpm.model.xml.ModelParseException;

public final class BpmnResourceTransformer
implements DeploymentResourceTransformer {
    private final BpmnTransformer bpmnTransformer;
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final Function<byte[], DirectBuffer> checksumGenerator;
    private final BpmnValidator validator;
    private final ProcessState processState;
    private final boolean enableStraightThroughProcessingLoopDetector;

    public BpmnResourceTransformer(KeyGenerator keyGenerator, StateWriter stateWriter, Function<byte[], DirectBuffer> checksumGenerator, ProcessState processState, ExpressionProcessor expressionProcessor, boolean enableStraightThroughProcessingLoopDetector, EngineConfiguration config, InstantSource clock) {
        this.bpmnTransformer = BpmnFactory.createTransformer(clock);
        this.keyGenerator = keyGenerator;
        this.stateWriter = stateWriter;
        this.checksumGenerator = checksumGenerator;
        this.processState = processState;
        this.validator = BpmnFactory.createValidator(clock, expressionProcessor, config.getValidatorsResultsOutputMaxSize());
        this.enableStraightThroughProcessingLoopDetector = enableStraightThroughProcessingLoopDetector;
    }

    @Override
    public Either<Failure, Void> createMetadata(DeploymentResource resource, DeploymentRecord deployment) {
        return this.readProcessDefinition(resource).flatMap(definition -> {
            String validationError = this.validator.validate((BpmnModelInstance)definition);
            if (validationError == null) {
                List<ExecutableProcess> executableProcesses = this.bpmnTransformer.transformDefinitions((BpmnModelInstance)definition);
                return this.checkForDuplicateBpmnId((BpmnModelInstance)definition, resource, deployment).flatMap(ok -> UnsupportedMultiTenantFeaturesValidator.validate(resource, executableProcesses, deployment.getTenantId())).flatMap(ok -> {
                    if (this.enableStraightThroughProcessingLoopDetector) {
                        return StraightThroughProcessingLoopValidator.validate(resource, executableProcesses);
                    }
                    return Either.right(null);
                }).map(ok -> {
                    this.createProcessMetadata(deployment, resource, (BpmnModelInstance)definition);
                    return null;
                });
            }
            String failureMessage = String.format("'%s': %s", resource.getResourceName(), validationError);
            return Either.left((Object)new Failure(failureMessage));
        });
    }

    @Override
    public Either<Failure, Void> writeRecords(DeploymentResource resource, DeploymentRecord deployment) {
        if (deployment.hasDuplicatesOnly()) {
            return Either.right(null);
        }
        DirectBuffer checksum = this.checksumGenerator.apply(resource.getResource());
        deployment.processesMetadata().stream().filter(metadata -> checksum.equals((Object)metadata.getChecksumBuffer())).forEach(metadata -> {
            long key = metadata.getKey();
            if (metadata.isDuplicate()) {
                key = this.keyGenerator.nextKey();
                metadata.setKey(key).setVersion(this.processState.getNextProcessVersion(metadata.getBpmnProcessId(), deployment.getTenantId())).setDuplicate(false).setDeploymentKey(deployment.getDeploymentKey());
            }
            this.stateWriter.appendFollowUpEvent(key, (Intent)ProcessIntent.CREATED, (RecordValue)new ProcessRecord().wrap(metadata, resource.getResource()));
        });
        return Either.right(null);
    }

    private Either<Failure, BpmnModelInstance> readProcessDefinition(DeploymentResource deploymentResource) {
        try {
            DirectBuffer resource = deploymentResource.getResourceBuffer();
            DirectBufferInputStream resourceStream = new DirectBufferInputStream(resource);
            return Either.right((Object)Bpmn.readModelFromStream((InputStream)resourceStream));
        }
        catch (ModelParseException e) {
            String failureMessage = String.format("'%s': %s", deploymentResource.getResourceName(), e.getCause().getMessage());
            return Either.left((Object)new Failure(failureMessage));
        }
    }

    private Either<Failure, ?> checkForDuplicateBpmnId(BpmnModelInstance process, DeploymentResource resource, DeploymentRecord record) {
        List<String> bpmnProcessIds = process.getDefinitions().getChildElementsByType(Process.class).stream().map(BaseElement::getId).toList();
        return record.getProcessesMetadata().stream().filter(metadata -> bpmnProcessIds.contains(metadata.getBpmnProcessId())).findFirst().map(previousResource -> {
            String failureMessage = String.format("Duplicated process id in resources '%s' and '%s'", previousResource.getResourceName(), resource.getResourceName());
            return Either.left((Object)new Failure(failureMessage));
        }).orElse(Either.right(null));
    }

    private void createProcessMetadata(DeploymentRecord deploymentEvent, DeploymentResource deploymentResource, BpmnModelInstance definition) {
        for (Process process : this.getExecutableProcesses(definition)) {
            String bpmnProcessId = process.getId();
            String tenantId = deploymentEvent.getTenantId();
            DeployedProcess lastProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)bpmnProcessId), tenantId);
            DirectBuffer lastDigest = this.processState.getLatestVersionDigest(BufferUtil.wrapString((String)bpmnProcessId), tenantId);
            DirectBuffer resourceDigest = this.checksumGenerator.apply(deploymentResource.getResource());
            ProcessMetadata processMetadata = (ProcessMetadata)deploymentEvent.processesMetadata().add();
            processMetadata.setBpmnProcessId(BufferUtil.wrapString((String)bpmnProcessId)).setChecksum(resourceDigest).setResourceName(deploymentResource.getResourceNameBuffer()).setTenantId(tenantId);
            this.getOptionalVersionTag(process).ifPresent(arg_0 -> ((ProcessMetadata)processMetadata).setVersionTag(arg_0));
            boolean isDuplicate = this.isDuplicateOfLatest(deploymentResource, resourceDigest, lastProcess, lastDigest);
            if (isDuplicate) {
                processMetadata.setKey(lastProcess.getKey()).setVersion(lastProcess.getVersion()).setDeploymentKey(lastProcess.getDeploymentKey()).setDuplicate(true);
                continue;
            }
            processMetadata.setKey(this.keyGenerator.nextKey()).setVersion(this.processState.getNextProcessVersion(bpmnProcessId, tenantId)).setDeploymentKey(deploymentEvent.getDeploymentKey());
        }
    }

    private List<Process> getExecutableProcesses(BpmnModelInstance modelInstance) {
        return modelInstance.getDefinitions().getChildElementsByType(Process.class).stream().filter(Process::isExecutable).toList();
    }

    private Optional<String> getOptionalVersionTag(Process process) {
        return Optional.ofNullable((ZeebeVersionTag)process.getSingleExtensionElement(ZeebeVersionTag.class)).map(ZeebeVersionTag::getValue);
    }

    private boolean isDuplicateOfLatest(DeploymentResource deploymentResource, DirectBuffer resourceDigest, DeployedProcess lastProcess, DirectBuffer lastVersionDigest) {
        return lastVersionDigest != null && lastProcess != null && lastVersionDigest.equals((Object)resourceDigest) && lastProcess.getResourceName().equals((Object)deploymentResource.getResourceNameBuffer());
    }
}

